/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.abris.avro.read.confluent;

import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.security.InvalidParameterException;
import org.apache.avro.Schema;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import za.co.absa.abris.avro.parsing.utils.AvroSchemaUtils$;
import za.co.absa.abris.avro.registry.AbrisRegistryClient;
import za.co.absa.abris.avro.registry.ConfluentRegistryClient;
import za.co.absa.abris.avro.registry.IdCoordinate;
import za.co.absa.abris.avro.registry.LatestVersion;
import za.co.absa.abris.avro.registry.NumVersion;
import za.co.absa.abris.avro.registry.SchemaCoordinate;
import za.co.absa.abris.avro.registry.SchemaSubject;
import za.co.absa.abris.avro.registry.SchemaVersion;
import za.co.absa.abris.avro.registry.SubjectCoordinate;

@ScalaSignature(bytes="\u0006\u0001\u0005Mc\u0001B\b\u0011\u0001}A\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\u0006s\u0001!\tA\u000f\u0005\u0006s\u0001!\tA\u0010\u0005\u0006\u001b\u0002!\tA\u0014\u0005\u00063\u0002!\tA\u0017\u0005\u0006A\u0002!\t!\u0019\u0005\u0006Y\u0002!\t!\u001c\u0005\u0006g\u0002!\t\u0001\u001e\u0005\u0007g\u0002!\t!a\u0002\t\u000f\u0005=\u0001\u0001\"\u0001\u0002\u0012!9\u00111\u0004\u0001\u0005\n\u0005u\u0001bBA\u0013\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003{\u0001A\u0011AA \u0011\u001d\tY\u0005\u0001C\u0001\u0003\u001b\u0012QbU2iK6\fW*\u00198bO\u0016\u0014(BA\t\u0013\u0003%\u0019wN\u001c4mk\u0016tGO\u0003\u0002\u0014)\u0005!!/Z1e\u0015\t)b#\u0001\u0003bmJ|'BA\f\u0019\u0003\u0015\t'M]5t\u0015\tI\"$\u0001\u0003bEN\f'BA\u000e\u001d\u0003\t\u0019wNC\u0001\u001e\u0003\tQ\u0018m\u0001\u0001\u0014\u0007\u0001\u0001c\u0005\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#E\u0001\u0004B]f\u0014VM\u001a\t\u0003OAj\u0011\u0001\u000b\u0006\u0003S)\n\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003W1\nQa\u001d9be.T!!\f\u0018\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0013aA8sO&\u0011\u0011\u0007\u000b\u0002\b\u0019><w-\u001b8h\u0003Q\u00198\r[3nCJ+w-[:uef\u001cE.[3oiB\u0011AgN\u0007\u0002k)\u0011a\u0007F\u0001\te\u0016<\u0017n\u001d;ss&\u0011\u0001(\u000e\u0002\u0014\u0003\n\u0014\u0018n\u001d*fO&\u001cHO]=DY&,g\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005mj\u0004C\u0001\u001f\u0001\u001b\u0005\u0001\u0002\"\u0002\u001a\u0003\u0001\u0004\u0019DCA\u001e@\u0011\u0015\u00114\u00011\u0001A!\t\t5*D\u0001C\u0015\t\u0019E)\u0001\u0004dY&,g\u000e\u001e\u0006\u0003\u000b\u001a\u000bab]2iK6\f'/Z4jgR\u0014\u0018P\u0003\u0002H\u0011\u0006)1.\u00194lC*\u0011\u0011#\u0013\u0006\u0002\u0015\u0006\u0011\u0011n\\\u0005\u0003\u0019\n\u0013AcU2iK6\f'+Z4jgR\u0014\u0018p\u00117jK:$\u0018!C4fiN\u001b\u0007.Z7b)\tyE\u000b\u0005\u0002Q%6\t\u0011K\u0003\u0002\u0016Y%\u00111+\u0015\u0002\u0007'\u000eDW-\\1\t\u000bU#\u0001\u0019\u0001,\u0002\u0015\r|wN\u001d3j]\u0006$X\r\u0005\u00025/&\u0011\u0001,\u000e\u0002\u0011'\u000eDW-\\1D_>\u0014H-\u001b8bi\u0016\fQbZ3u'\u000eDW-\\1Cs&#GCA(\\\u0011\u0015aV\u00011\u0001^\u0003!\u00198\r[3nC&#\u0007CA\u0011_\u0013\ty&EA\u0002J]R\fAdZ3u'\u000eDW-\\1CsN+(M[3di\u0006sGMV3sg&|g\u000eF\u0002PE\u001eDQa\u0019\u0004A\u0002\u0011\fqa];cU\u0016\u001cG\u000f\u0005\u00025K&\u0011a-\u000e\u0002\u000e'\u000eDW-\\1Tk\nTWm\u0019;\t\u000b!4\u0001\u0019A5\u0002\u000fY,'o]5p]B\u0011AG[\u0005\u0003WV\u0012QbU2iK6\fg+\u001a:tS>t\u0017\u0001J4fiN\u001b\u0007.Z7b\u001b\u0016$\u0018\rZ1uC\nK8+\u001e2kK\u000e$\u0018I\u001c3WKJ\u001c\u0018n\u001c8\u0015\u00079\f(\u000f\u0005\u0002B_&\u0011\u0001O\u0011\u0002\u000f'\u000eDW-\\1NKR\fG-\u0019;b\u0011\u0015\u0019w\u00011\u0001e\u0011\u0015Aw\u00011\u0001j\u0003!\u0011XmZ5ti\u0016\u0014HcA/vm\")1\r\u0003a\u0001I\")q\u000f\u0003a\u0001q\u0006a1o\u00195f[\u0006\u001cFO]5oOB\u0019\u00110!\u0001\u000f\u0005it\bCA>#\u001b\u0005a(BA?\u001f\u0003\u0019a$o\\8u}%\u0011qPI\u0001\u0007!J,G-\u001a4\n\t\u0005\r\u0011Q\u0001\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005}\u0014C#B/\u0002\n\u0005-\u0001\"B2\n\u0001\u0004!\u0007BBA\u0007\u0013\u0001\u0007q*\u0001\u0004tG\",W.Y\u0001\u0007KbL7\u000f^:\u0015\t\u0005M\u0011\u0011\u0004\t\u0004C\u0005U\u0011bAA\fE\t9!i\\8mK\u0006t\u0007\"B2\u000b\u0001\u0004!\u0017\u0001D5t\u0007>l\u0007/\u0019;jE2,GCBA\n\u0003?\t\u0019\u0003\u0003\u0004\u0002\"-\u0001\raT\u0001\n]\u0016<8k\u00195f[\u0006DQaY\u0006A\u0002\u0011\f\u0011dZ3u\u00032d7k\u00195f[\u0006\u001cx+\u001b;i\u001b\u0016$\u0018\rZ1uCR!\u0011\u0011FA\u001e!\u0015\tY#!\u000eo\u001d\u0011\ti#!\r\u000f\u0007m\fy#C\u0001$\u0013\r\t\u0019DI\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9$!\u000f\u0003\t1K7\u000f\u001e\u0006\u0004\u0003g\u0011\u0003\"B2\r\u0001\u0004!\u0017\u0001\u00064j]\u0012,\u0015/^5wC2,g\u000e^*dQ\u0016l\u0017\r\u0006\u0004\u0002B\u0005\u001d\u0013\u0011\n\t\u0005C\u0005\rS,C\u0002\u0002F\t\u0012aa\u00149uS>t\u0007BBA\u0007\u001b\u0001\u0007q\nC\u0003d\u001b\u0001\u0007A-A\u0010hKRLe-\u0012=jgR\u001cxJ]#mg\u0016\u0014VmZ5ti\u0016\u00148k\u00195f[\u0006$R!XA(\u0003#Ba!!\u0004\u000f\u0001\u0004y\u0005\"B2\u000f\u0001\u0004!\u0007")
public class SchemaManager
implements Logging {
    private final AbrisRegistryClient schemaRegistryClient;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Schema getSchema(SchemaCoordinate coordinate) {
        Schema schema;
        SchemaCoordinate schemaCoordinate = coordinate;
        if (schemaCoordinate instanceof IdCoordinate) {
            IdCoordinate idCoordinate = (IdCoordinate)schemaCoordinate;
            int id = idCoordinate.schemaId();
            schema = this.getSchemaById(id);
        } else if (schemaCoordinate instanceof SubjectCoordinate) {
            SubjectCoordinate subjectCoordinate = (SubjectCoordinate)schemaCoordinate;
            SchemaSubject subject = subjectCoordinate.subject();
            SchemaVersion version = subjectCoordinate.version();
            schema = this.getSchemaBySubjectAndVersion(subject, version);
        } else {
            throw new MatchError((Object)schemaCoordinate);
        }
        return schema;
    }

    public Schema getSchemaById(int schemaId) {
        return this.schemaRegistryClient.getById(schemaId);
    }

    public Schema getSchemaBySubjectAndVersion(SchemaSubject subject, SchemaVersion version) {
        SchemaMetadata metadata = this.getSchemaMetadataBySubjectAndVersion(subject, version);
        return AvroSchemaUtils$.MODULE$.parse(metadata.getSchema());
    }

    public SchemaMetadata getSchemaMetadataBySubjectAndVersion(SchemaSubject subject, SchemaVersion version) {
        SchemaMetadata schemaMetadata;
        SchemaVersion schemaVersion = version;
        if (schemaVersion instanceof NumVersion) {
            NumVersion numVersion = (NumVersion)schemaVersion;
            int versionInt = numVersion.num();
            schemaMetadata = this.schemaRegistryClient.getSchemaMetadata(subject.asString(), versionInt);
        } else if (schemaVersion instanceof LatestVersion) {
            schemaMetadata = this.schemaRegistryClient.getLatestSchemaMetadata(subject.asString());
        } else {
            throw new MatchError((Object)schemaVersion);
        }
        return schemaMetadata;
    }

    public int register(SchemaSubject subject, String schemaString) {
        return this.register(subject, AvroSchemaUtils$.MODULE$.parse(schemaString));
    }

    public int register(SchemaSubject subject, Schema schema) {
        if (this.exists(subject) && !this.isCompatible(schema, subject)) {
            throw new InvalidParameterException(new StringBuilder(129).append("Schema registration failed. Schema for subject:'").append(subject).append("' ").append("already exists and it is not compatible with schema you are trying to register.").toString());
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(76).append("AvroSchemaUtils.registerIfCompatibleSchema: Registering schema for subject: ").append(subject).toString());
        return this.schemaRegistryClient.register(subject.asString(), schema);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean exists(SchemaSubject subject) {
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> $this.schemaRegistryClient.getLatestSchemaMetadata(subject.asString()));
        if (try_ instanceof Success) {
            return true;
        }
        if (try_ instanceof Failure) {
            RestClientException restClientException;
            bl = true;
            failure = (Failure)try_;
            Throwable e = failure.exception();
            if (e instanceof RestClientException && (restClientException = (RestClientException)e).getStatus() == 404) {
                return false;
            }
        }
        if (!bl) throw new MatchError((Object)try_);
        Throwable e = failure.exception();
        throw e;
    }

    private boolean isCompatible(Schema newSchema, SchemaSubject subject) {
        return this.schemaRegistryClient.testCompatibility(subject.asString(), newSchema);
    }

    /*
     * Unable to fully structure code
     */
    public List<SchemaMetadata> getAllSchemasWithMetadata(SchemaSubject subject) {
        block4: {
            block3: {
                var4_2 = false;
                var5_3 = null;
                var6_4 = Try$.MODULE$.apply((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$getAllSchemasWithMetadata$1(za.co.absa.abris.avro.read.confluent.SchemaManager za.co.absa.abris.avro.registry.SchemaSubject ), ()Ljava/util/List;)((SchemaManager)this, (SchemaSubject)subject));
                if (!(var6_4 instanceof Success)) break block3;
                var7_5 = (Success)var6_4;
                l = (java.util.List)var7_5.value();
                var2_7 = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(l).asScala()).toList();
                break block4;
            }
            if (!(var6_4 instanceof Failure)) ** GOTO lbl-1000
            var4_2 = true;
            var5_3 = (Failure)var6_4;
            e = var5_3.exception();
            if (e instanceof RestClientException && (var10_9 = (RestClientException)e).getStatus() == 404) {
                var2_7 = List$.MODULE$.empty();
            } else lbl-1000:
            // 2 sources

            {
                if (var4_2) {
                    e = var5_3.exception();
                    throw e;
                }
                throw new MatchError((Object)var6_4);
            }
        }
        versions = var2_7;
        return (List)versions.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$getAllSchemasWithMetadata$2(za.co.absa.abris.avro.read.confluent.SchemaManager za.co.absa.abris.avro.registry.SchemaSubject java.lang.Integer ), (Ljava/lang/Integer;)Lio/confluent/kafka/schemaregistry/client/SchemaMetadata;)((SchemaManager)this, (SchemaSubject)subject), List$.MODULE$.canBuildFrom());
    }

    public Option<Object> findEquivalentSchema(Schema schema, SchemaSubject subject) {
        Option maybeIdenticalSchemaMetadata = this.getAllSchemasWithMetadata(subject).find((Function1 & Serializable & scala.Serializable)sm -> BoxesRunTime.boxToBoolean((boolean)SchemaManager.$anonfun$findEquivalentSchema$1(schema, sm)));
        return maybeIdenticalSchemaMetadata.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.getId()));
    }

    public int getIfExistsOrElseRegisterSchema(Schema schema, SchemaSubject subject) {
        Option<Object> maybeSchemaId = this.findEquivalentSchema(schema, subject);
        return BoxesRunTime.unboxToInt((Object)maybeSchemaId.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.register(subject, schema)));
    }

    public static final /* synthetic */ java.util.List $anonfun$getAllSchemasWithMetadata$1(SchemaManager $this, SchemaSubject subject$3) {
        return $this.schemaRegistryClient.getAllVersions(subject$3.asString());
    }

    public static final /* synthetic */ SchemaMetadata $anonfun$getAllSchemasWithMetadata$2(SchemaManager $this, SchemaSubject subject$3, Integer x$1) {
        return $this.schemaRegistryClient.getSchemaMetadata(subject$3.asString(), Predef$.MODULE$.Integer2int(x$1));
    }

    public static final /* synthetic */ boolean $anonfun$findEquivalentSchema$1(Schema schema$1, SchemaMetadata sm) {
        return AvroSchemaUtils$.MODULE$.parse(sm.getSchema()).equals((Object)schema$1);
    }

    public SchemaManager(AbrisRegistryClient schemaRegistryClient) {
        this.schemaRegistryClient = schemaRegistryClient;
        Logging.$init$((Logging)this);
    }

    public SchemaManager(SchemaRegistryClient schemaRegistryClient) {
        this(new ConfluentRegistryClient(schemaRegistryClient));
    }
}

