/*
 * Decompiled with CFR 0.152.
 */
package us.springett.parsers.cpe;

import java.util.NoSuchElementException;
import us.springett.parsers.cpe.Cpe;
import us.springett.parsers.cpe.CpeBuilder;
import us.springett.parsers.cpe.exceptions.CpeEncodingException;
import us.springett.parsers.cpe.exceptions.CpeParsingException;
import us.springett.parsers.cpe.exceptions.CpeValidationException;
import us.springett.parsers.cpe.internal.util.Cpe23PartIterator;
import us.springett.parsers.cpe.util.Convert;

public final class CpeParser {
    private CpeParser() {
    }

    public static Cpe parse(String cpeString) throws CpeParsingException {
        if (cpeString == null) {
            throw new CpeParsingException("CPE String is null and cannot be parsed");
        }
        if (cpeString.regionMatches(0, "cpe:/", 0, 5)) {
            return CpeParser.parse22(cpeString, false);
        }
        if (cpeString.regionMatches(0, "cpe:2.3:", 0, 8)) {
            return CpeParser.parse23(cpeString);
        }
        throw new CpeParsingException("The CPE string specified does not conform to the CPE 2.2 or 2.3 specification");
    }

    public static Cpe parse(String cpeString, boolean lenient) throws CpeParsingException {
        if (cpeString == null) {
            throw new CpeParsingException("CPE String is null and cannot be parsed");
        }
        if (cpeString.regionMatches(0, "cpe:/", 0, 5)) {
            return CpeParser.parse22(cpeString, lenient);
        }
        if (cpeString.regionMatches(0, "cpe:2.3:", 0, 8)) {
            return CpeParser.parse23(cpeString, lenient);
        }
        throw new CpeParsingException("The CPE string specified does not conform to the CPE 2.2 or 2.3 specification");
    }

    protected static Cpe parse22(String cpeString) throws CpeParsingException {
        return CpeParser.parse22(cpeString, false);
    }

    protected static Cpe parse22(String cpeString, boolean lenient) throws CpeParsingException {
        if (cpeString == null || cpeString.isEmpty()) {
            throw new CpeParsingException("CPE String is null ir enpty - unable to parse");
        }
        CpeBuilder cb = new CpeBuilder();
        String[] parts = cpeString.split(":");
        if (parts.length <= 1 || parts.length > 8) {
            throw new CpeParsingException("CPE String is invalid - too many components specified: " + cpeString);
        }
        if (parts[1].length() != 2) {
            throw new CpeParsingException("CPE String contains a malformed part: " + cpeString);
        }
        try {
            cb.part(parts[1].substring(1));
            if (parts.length > 2) {
                cb.wfVendor(Convert.cpeUriToWellFormed(parts[2], lenient));
            }
            if (parts.length > 3) {
                cb.wfProduct(Convert.cpeUriToWellFormed(parts[3], lenient));
            }
            if (parts.length > 4) {
                cb.wfVersion(Convert.cpeUriToWellFormed(parts[4], lenient));
            }
            if (parts.length > 5) {
                cb.wfUpdate(Convert.cpeUriToWellFormed(parts[5], lenient));
            }
            if (parts.length > 6) {
                CpeParser.unpackEdition(parts[6], cb, lenient);
            }
            if (parts.length > 7) {
                cb.wfLanguage(Convert.cpeUriToWellFormed(parts[7], lenient));
            }
            return cb.build();
        }
        catch (CpeEncodingException | CpeValidationException ex) {
            throw new CpeParsingException(ex.getMessage());
        }
    }

    protected static void unpackEdition(String edition, CpeBuilder cb, boolean lenient) throws CpeParsingException {
        if (edition == null || edition.isEmpty()) {
            return;
        }
        try {
            String[] unpacked = edition.split("~");
            if (edition.startsWith("~")) {
                if (unpacked.length > 1) {
                    cb.wfEdition(Convert.cpeUriToWellFormed(unpacked[1], lenient));
                }
                if (unpacked.length > 2) {
                    cb.wfSwEdition(Convert.cpeUriToWellFormed(unpacked[2], lenient));
                }
                if (unpacked.length > 3) {
                    cb.wfTargetSw(Convert.cpeUriToWellFormed(unpacked[3], lenient));
                }
                if (unpacked.length > 4) {
                    cb.wfTargetHw(Convert.cpeUriToWellFormed(unpacked[4], lenient));
                }
                if (unpacked.length > 5) {
                    cb.wfOther(Convert.cpeUriToWellFormed(unpacked[5], lenient));
                }
                if (unpacked.length > 6) {
                    throw new CpeParsingException("Invalid packed edition");
                }
            } else {
                cb.wfEdition(Convert.cpeUriToWellFormed(edition, lenient));
            }
        }
        catch (CpeEncodingException ex) {
            throw new CpeParsingException(ex.getMessage());
        }
    }

    protected static Cpe parse23(String cpeString) throws CpeParsingException {
        return CpeParser.parse23(cpeString, false);
    }

    protected static Cpe parse23(String cpeString, boolean lenient) throws CpeParsingException {
        if (cpeString == null || cpeString.isEmpty()) {
            throw new CpeParsingException("CPE String is null ir enpty - unable to parse");
        }
        CpeBuilder cb = new CpeBuilder();
        Cpe23PartIterator cpe = new Cpe23PartIterator(cpeString);
        try {
            cb.part(cpe.next());
            cb.wfVendor(Convert.fsToWellFormed(cpe.next(), lenient));
            cb.wfProduct(Convert.fsToWellFormed(cpe.next(), lenient));
            cb.wfVersion(Convert.fsToWellFormed(cpe.next(), lenient));
            cb.wfUpdate(Convert.fsToWellFormed(cpe.next(), lenient));
            cb.wfEdition(Convert.fsToWellFormed(cpe.next(), lenient));
            cb.wfLanguage(Convert.fsToWellFormed(cpe.next(), lenient));
            cb.wfSwEdition(Convert.fsToWellFormed(cpe.next(), lenient));
            cb.wfTargetSw(Convert.fsToWellFormed(cpe.next(), lenient));
            cb.wfTargetHw(Convert.fsToWellFormed(cpe.next(), lenient));
            cb.wfOther(Convert.fsToWellFormed(cpe.next(), lenient));
        }
        catch (NoSuchElementException ex) {
            throw new CpeParsingException("Invalid CPE (too few components): " + cpeString);
        }
        if (cpe.hasNext()) {
            throw new CpeParsingException("Invalid CPE (too many components): " + cpeString);
        }
        try {
            return cb.build();
        }
        catch (CpeValidationException ex) {
            throw new CpeParsingException(ex.getMessage());
        }
    }
}

