/*
 * Decompiled with CFR 0.152.
 */
package sf.util;

import java.util.Formatter;
import java.util.function.Supplier;
import sf.util.Utility;

public final class StringFormat
implements Supplier<String> {
    private final String format;
    private final Object[] args;

    public StringFormat(String format, Object ... args) {
        this.format = format;
        this.args = args;
    }

    @Override
    public String get() {
        if (Utility.isBlank(this.format) || this.args == null || this.args.length == 0) {
            return this.format;
        }
        try (Formatter formatter = new Formatter();){
            String string = formatter.format(this.format, this.args).toString();
            return string;
        }
    }

    public String toString() {
        return this.get();
    }
}

