/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.operation;

import schemacrawler.schemacrawler.Config;
import schemacrawler.tools.text.base.BaseTextOptionsBuilder;
import schemacrawler.tools.text.operation.OperationOptions;

public final class OperationOptionsBuilder
extends BaseTextOptionsBuilder<OperationOptionsBuilder, OperationOptions> {
    private static final String SHOW_LOBS = "schemacrawler.format.data.show_lobs";
    protected boolean isShowLobs;

    public static OperationOptionsBuilder builder() {
        return new OperationOptionsBuilder();
    }

    public static OperationOptionsBuilder builder(OperationOptions options) {
        return new OperationOptionsBuilder().fromOptions(options);
    }

    public static OperationOptions newOperationOptions() {
        return new OperationOptionsBuilder().toOptions();
    }

    public static OperationOptions newOperationOptions(Config config) {
        return new OperationOptionsBuilder().fromConfig(config).toOptions();
    }

    private OperationOptionsBuilder() {
    }

    @Override
    public OperationOptionsBuilder fromConfig(Config map) {
        if (map == null) {
            return this;
        }
        super.fromConfig(map);
        Config config = new Config(map);
        this.isShowLobs = config.getBooleanValue(SHOW_LOBS, false);
        return this;
    }

    @Override
    public OperationOptionsBuilder fromOptions(OperationOptions options) {
        if (options == null) {
            return this;
        }
        super.fromOptions(options);
        this.isShowLobs = options.isShowLobs();
        return this;
    }

    public OperationOptionsBuilder showLobs() {
        return this.showLobs(true);
    }

    public OperationOptionsBuilder showLobs(boolean value) {
        this.isShowLobs = value;
        return this;
    }

    @Override
    public Config toConfig() {
        Config config = super.toConfig();
        config.setBooleanValue(SHOW_LOBS, this.isShowLobs);
        return config;
    }

    @Override
    public OperationOptions toOptions() {
        return new OperationOptions(this);
    }
}

