/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.base;

import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.OptionsBuilder;
import schemacrawler.tools.text.base.BaseTextOptions;
import schemacrawler.utility.IdentifierQuotingStrategy;

public abstract class BaseTextOptionsBuilder<B extends BaseTextOptionsBuilder<B, O>, O extends BaseTextOptions>
implements OptionsBuilder<BaseTextOptionsBuilder<B, O>, O> {
    protected static final String SCHEMACRAWLER_FORMAT_PREFIX = "schemacrawler.format.";
    private static final String NO_HEADER = "schemacrawler.format.no_header";
    private static final String NO_FOOTER = "schemacrawler.format.no_footer";
    private static final String NO_SCHEMACRAWLER_INFO = "schemacrawler.format.no_schemacrawler_info";
    private static final String SHOW_DATABASE_INFO = "schemacrawler.format.show_database_info";
    private static final String SHOW_JDBC_DRIVER_INFO = "schemacrawler.format.show_jdbc_driver_info";
    private static final String APPEND_OUTPUT = "schemacrawler.format.append_output";
    private static final String SHOW_UNQUALIFIED_NAMES = "schemacrawler.format.show_unqualified_names";
    private static final String SORT_ALPHABETICALLY_TABLES = "schemacrawler.format.sort_alphabetically.tables";
    private static final String SORT_ALPHABETICALLY_TABLE_COLUMNS = "schemacrawler.format.sort_alphabetically.table_columns";
    private static final String SORT_ALPHABETICALLY_ROUTINES = "schemacrawler.format.sort_alphabetically.routines";
    private static final String SORT_ALPHABETICALLY_ROUTINE_COLUMNS = "schemacrawler.format.sort_alphabetically.routine_columns";
    private static final String NO_SCHEMA_COLORS = "schemacrawler.format.no_schema_colors";
    private static final String IDENTIFIER_QUOTING_STRATEGY = "schemacrawler.format.identifier_quoting_strategy";
    protected boolean isAlphabeticalSortForRoutineColumns;
    protected boolean isAlphabeticalSortForRoutines;
    protected boolean isAlphabeticalSortForTableColumns;
    protected boolean isAlphabeticalSortForTables = true;
    protected boolean isAppendOutput;
    protected boolean isNoFooter;
    protected boolean isNoHeader;
    protected boolean isNoSchemaCrawlerInfo;
    protected boolean isShowDatabaseInfo;
    protected boolean isShowJdbcDriverInfo;
    protected boolean isShowUnqualifiedNames;
    protected boolean isNoSchemaColors;
    protected IdentifierQuotingStrategy identifierQuotingStrategy;

    protected BaseTextOptionsBuilder() {
    }

    public final B appendOutput() {
        this.isAppendOutput = true;
        return (B)this;
    }

    public B fromConfig(Config map) {
        if (map == null) {
            return (B)this;
        }
        Config config = new Config(map);
        this.isNoFooter = config.getBooleanValue(NO_FOOTER);
        this.isNoHeader = config.getBooleanValue(NO_HEADER);
        this.isShowDatabaseInfo = config.getBooleanValue(SHOW_DATABASE_INFO);
        this.isShowJdbcDriverInfo = config.getBooleanValue(SHOW_JDBC_DRIVER_INFO);
        this.isNoSchemaCrawlerInfo = config.getBooleanValue(NO_SCHEMACRAWLER_INFO);
        this.isAppendOutput = config.getBooleanValue(APPEND_OUTPUT);
        this.isShowUnqualifiedNames = config.getBooleanValue(SHOW_UNQUALIFIED_NAMES);
        this.isAlphabeticalSortForTables = config.getBooleanValue(SORT_ALPHABETICALLY_TABLES, this.isAlphabeticalSortForTables);
        this.isAlphabeticalSortForTableColumns = config.getBooleanValue(SORT_ALPHABETICALLY_TABLE_COLUMNS, this.isAlphabeticalSortForTableColumns);
        this.isAlphabeticalSortForRoutines = config.getBooleanValue(SORT_ALPHABETICALLY_ROUTINES, this.isAlphabeticalSortForRoutines);
        this.isAlphabeticalSortForRoutineColumns = config.getBooleanValue(SORT_ALPHABETICALLY_ROUTINE_COLUMNS, this.isAlphabeticalSortForRoutineColumns);
        this.isNoSchemaColors = config.getBooleanValue(NO_SCHEMA_COLORS);
        this.identifierQuotingStrategy = config.getEnumValue(IDENTIFIER_QUOTING_STRATEGY, IdentifierQuotingStrategy.quote_if_special_characters_and_reserved_words);
        return (B)this;
    }

    public B fromOptions(O options) {
        if (options == null) {
            return (B)this;
        }
        this.isNoFooter = ((BaseTextOptions)options).isNoFooter();
        this.isNoHeader = ((BaseTextOptions)options).isNoHeader();
        this.isShowDatabaseInfo = ((BaseTextOptions)options).isShowDatabaseInfo();
        this.isShowJdbcDriverInfo = ((BaseTextOptions)options).isShowJdbcDriverInfo();
        this.isNoSchemaCrawlerInfo = ((BaseTextOptions)options).isNoSchemaCrawlerInfo();
        this.isAppendOutput = ((BaseTextOptions)options).isAppendOutput();
        this.isShowUnqualifiedNames = ((BaseTextOptions)options).isShowUnqualifiedNames();
        this.isAlphabeticalSortForTables = ((BaseTextOptions)options).isAlphabeticalSortForTables();
        this.isAlphabeticalSortForTableColumns = ((BaseTextOptions)options).isAlphabeticalSortForTableColumns();
        this.isAlphabeticalSortForRoutines = ((BaseTextOptions)options).isAlphabeticalSortForRoutines();
        this.isAlphabeticalSortForRoutineColumns = ((BaseTextOptions)options).isAlphabeticalSortForRoutineColumns();
        this.isNoSchemaColors = ((BaseTextOptions)options).isNoSchemaColors();
        this.identifierQuotingStrategy = ((BaseTextOptions)options).getIdentifierQuotingStrategy();
        return (B)this;
    }

    public final B noFooter() {
        return this.noFooter(true);
    }

    public final B noFooter(boolean value) {
        this.isNoFooter = value;
        return (B)this;
    }

    public final B noHeader() {
        return this.noHeader(true);
    }

    public final B noHeader(boolean value) {
        this.isNoHeader = value;
        return (B)this;
    }

    public final B noInfo() {
        return this.noInfo(true);
    }

    public final B noInfo(boolean value) {
        this.isNoSchemaCrawlerInfo = value;
        this.isShowDatabaseInfo = !value;
        this.isShowJdbcDriverInfo = !value;
        return (B)this;
    }

    public final B noSchemaColors() {
        return this.noSchemaColors(true);
    }

    public final B noSchemaColors(boolean value) {
        this.isNoSchemaColors = value;
        return (B)this;
    }

    public final B noSchemaCrawlerInfo() {
        return this.noSchemaCrawlerInfo(true);
    }

    public final B noSchemaCrawlerInfo(boolean value) {
        this.isNoSchemaCrawlerInfo = value;
        return (B)this;
    }

    public final B overwriteOutput() {
        this.isAppendOutput = false;
        return (B)this;
    }

    public final B showDatabaseInfo() {
        return this.showDatabaseInfo(true);
    }

    public final B showDatabaseInfo(boolean value) {
        this.isShowDatabaseInfo = value;
        return (B)this;
    }

    public final B showJdbcDriverInfo() {
        return this.showJdbcDriverInfo(true);
    }

    public final B showJdbcDriverInfo(boolean value) {
        this.isShowJdbcDriverInfo = value;
        return (B)this;
    }

    public final B showUnqualifiedNames() {
        return this.showUnqualifiedNames(true);
    }

    public final B showUnqualifiedNames(boolean value) {
        this.isShowUnqualifiedNames = value;
        return (B)this;
    }

    public final B sortInOut() {
        return this.sortInOut(true);
    }

    public final B sortInOut(boolean value) {
        this.isAlphabeticalSortForRoutineColumns = value;
        return (B)this;
    }

    public final B sortRoutines() {
        return this.sortRoutines(true);
    }

    public final B sortRoutines(boolean value) {
        this.isAlphabeticalSortForRoutines = value;
        return (B)this;
    }

    public final B sortTableColumns() {
        return this.sortTableColumns(true);
    }

    public final B sortTableColumns(boolean value) {
        this.isAlphabeticalSortForTableColumns = value;
        return (B)this;
    }

    public final B sortTables() {
        return this.sortTables(true);
    }

    public final B sortTables(boolean value) {
        this.isAlphabeticalSortForTables = value;
        return (B)this;
    }

    @Override
    public Config toConfig() {
        Config config = new Config();
        config.setBooleanValue(NO_FOOTER, this.isNoFooter);
        config.setBooleanValue(NO_HEADER, this.isNoHeader);
        config.setBooleanValue(NO_SCHEMACRAWLER_INFO, this.isNoSchemaCrawlerInfo);
        config.setBooleanValue(SHOW_DATABASE_INFO, this.isShowDatabaseInfo);
        config.setBooleanValue(SHOW_JDBC_DRIVER_INFO, this.isShowJdbcDriverInfo);
        config.setBooleanValue(APPEND_OUTPUT, this.isAppendOutput);
        config.setBooleanValue(SHOW_UNQUALIFIED_NAMES, this.isShowUnqualifiedNames);
        config.setBooleanValue(SORT_ALPHABETICALLY_TABLES, this.isAlphabeticalSortForTables);
        config.setBooleanValue(SORT_ALPHABETICALLY_TABLE_COLUMNS, this.isAlphabeticalSortForTableColumns);
        config.setBooleanValue(SORT_ALPHABETICALLY_ROUTINES, this.isAlphabeticalSortForRoutines);
        config.setBooleanValue(SORT_ALPHABETICALLY_ROUTINE_COLUMNS, this.isAlphabeticalSortForRoutineColumns);
        config.setBooleanValue(NO_SCHEMA_COLORS, this.isNoSchemaColors);
        config.setEnumValue(IDENTIFIER_QUOTING_STRATEGY, this.identifierQuotingStrategy);
        return config;
    }

    public final B withIdentifierQuotingStrategy(IdentifierQuotingStrategy identifierQuotingStrategy) {
        this.identifierQuotingStrategy = identifierQuotingStrategy == null ? IdentifierQuotingStrategy.quote_none : identifierQuotingStrategy;
        return (B)this;
    }
}

