/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.base;

import java.util.Objects;
import schemacrawler.schemacrawler.Options;
import schemacrawler.tools.text.base.BaseTextOptionsBuilder;
import schemacrawler.utility.IdentifierQuotingStrategy;

public abstract class BaseTextOptions
implements Options {
    private final boolean isAlphabeticalSortForTables;
    private final boolean isAlphabeticalSortForTableColumns;
    private final boolean isAlphabeticalSortForRoutines;
    private final boolean isAlphabeticalSortForRoutineColumns;
    private final boolean isAppendOutput;
    private final boolean isNoFooter;
    private final boolean isNoHeader;
    private final boolean isNoSchemaCrawlerInfo;
    private final boolean isShowDatabaseInfo;
    private final boolean isShowJdbcDriverInfo;
    private final boolean isShowUnqualifiedNames;
    private final boolean isNoSchemaColors;
    private final IdentifierQuotingStrategy identifierQuotingStrategy;

    protected BaseTextOptions(BaseTextOptionsBuilder<?, ? extends BaseTextOptions> builder) {
        Objects.requireNonNull(builder, "No builder provided");
        this.isAlphabeticalSortForTables = builder.isAlphabeticalSortForTables;
        this.isAlphabeticalSortForTableColumns = builder.isAlphabeticalSortForTableColumns;
        this.isAlphabeticalSortForRoutines = builder.isAlphabeticalSortForRoutines;
        this.isAlphabeticalSortForRoutineColumns = builder.isAlphabeticalSortForRoutineColumns;
        this.isAppendOutput = builder.isAppendOutput;
        this.isNoFooter = builder.isNoFooter;
        this.isNoHeader = builder.isNoHeader;
        this.isNoSchemaCrawlerInfo = builder.isNoSchemaCrawlerInfo;
        this.isShowDatabaseInfo = builder.isShowDatabaseInfo;
        this.isShowJdbcDriverInfo = builder.isShowJdbcDriverInfo;
        this.isShowUnqualifiedNames = builder.isShowUnqualifiedNames;
        this.isNoSchemaColors = builder.isNoSchemaColors;
        this.identifierQuotingStrategy = builder.identifierQuotingStrategy;
    }

    public IdentifierQuotingStrategy getIdentifierQuotingStrategy() {
        return this.identifierQuotingStrategy;
    }

    public boolean isAlphabeticalSortForRoutineColumns() {
        return this.isAlphabeticalSortForRoutineColumns;
    }

    public boolean isAlphabeticalSortForRoutines() {
        return this.isAlphabeticalSortForRoutines;
    }

    public boolean isAlphabeticalSortForTableColumns() {
        return this.isAlphabeticalSortForTableColumns;
    }

    public boolean isAlphabeticalSortForTables() {
        return this.isAlphabeticalSortForTables;
    }

    public boolean isAppendOutput() {
        return this.isAppendOutput;
    }

    public boolean isNoFooter() {
        return this.isNoFooter;
    }

    public boolean isNoHeader() {
        return this.isNoHeader;
    }

    public boolean isNoInfo() {
        return this.isNoSchemaCrawlerInfo && !this.isShowDatabaseInfo && !this.isShowJdbcDriverInfo;
    }

    public boolean isNoSchemaColors() {
        return this.isNoSchemaColors;
    }

    public boolean isNoSchemaCrawlerInfo() {
        return this.isNoSchemaCrawlerInfo;
    }

    public boolean isShowDatabaseInfo() {
        return this.isShowDatabaseInfo;
    }

    public boolean isShowJdbcDriverInfo() {
        return this.isShowJdbcDriverInfo;
    }

    public boolean isShowUnqualifiedNames() {
        return this.isShowUnqualifiedNames;
    }
}

