/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.thymeleaf;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.tools.executable.CommandProvider;
import schemacrawler.tools.executable.SchemaCrawlerCommand;
import schemacrawler.tools.integration.thymeleaf.ThymeleafRenderer;
import schemacrawler.tools.iosource.ClasspathInputResource;
import schemacrawler.tools.iosource.EmptyInputResource;
import schemacrawler.tools.iosource.InputResource;
import schemacrawler.tools.options.OutputOptions;
import sf.util.SchemaCrawlerLogger;

public class ThymeleafCommandProvider
implements CommandProvider {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(ThymeleafCommandProvider.class.getName());

    @Override
    public String getDescription() {
        return "Render a Thymeleaf template against a schema";
    }

    @Override
    public InputResource getHelp() {
        String helpResource = "/help/ThymeleafRenderer.txt";
        try {
            return new ClasspathInputResource("/help/ThymeleafRenderer.txt");
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, String.format("Could not load help resource <%s>", "/help/ThymeleafRenderer.txt"), (Throwable)e);
            return new EmptyInputResource();
        }
    }

    @Override
    public Collection<String> getSupportedCommands() {
        return Arrays.asList("thymeleaf");
    }

    @Override
    public SchemaCrawlerCommand newSchemaCrawlerCommand(String command) {
        ThymeleafRenderer scCommand = new ThymeleafRenderer();
        return scCommand;
    }

    @Override
    public boolean supportsSchemaCrawlerCommand(String command, SchemaCrawlerOptions schemaCrawlerOptions, OutputOptions outputOptions) {
        return "thymeleaf".equals(command);
    }
}

