/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import java.util.ArrayList;
import java.util.Collection;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.tools.executable.ExecutableCommandProvider;
import schemacrawler.tools.executable.SchemaCrawlerCommand;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.options.TextOutputFormat;
import schemacrawler.tools.text.schema.SchemaTextDetailType;
import schemacrawler.tools.text.schema.SchemaTextRenderer;
import sf.util.Utility;

public final class SchemaExecutableCommandProvider
extends ExecutableCommandProvider {
    private static final Collection<String> supportedCommands = SchemaExecutableCommandProvider.supportedCommands();

    private static Collection<String> supportedCommands() {
        ArrayList<String> supportedCommands = new ArrayList<String>();
        for (SchemaTextDetailType schemaTextDetailType : SchemaTextDetailType.values()) {
            supportedCommands.add(schemaTextDetailType.name());
        }
        return supportedCommands;
    }

    public SchemaExecutableCommandProvider() {
        super(supportedCommands, "");
    }

    @Override
    public String getDescription() {
        return "Display schema information at different levels of detail";
    }

    @Override
    public Collection<String> getSupportedCommands() {
        return SchemaExecutableCommandProvider.supportedCommands();
    }

    @Override
    public SchemaCrawlerCommand newSchemaCrawlerCommand(String command) throws SchemaCrawlerException {
        SchemaTextRenderer scCommand = new SchemaTextRenderer(command);
        return scCommand;
    }

    @Override
    public boolean supportsSchemaCrawlerCommand(String command, SchemaCrawlerOptions schemaCrawlerOptions, OutputOptions outputOptions) {
        if (Utility.isBlank(command) || outputOptions == null) {
            return false;
        }
        String outputFormatValue = outputOptions.getOutputFormatValue();
        return supportedCommands.contains(command) && (Utility.isBlank(outputFormatValue) || TextOutputFormat.isSupportedFormat(outputFormatValue));
    }
}

