/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.executable.BaseCommandChain;
import schemacrawler.tools.executable.SchemaCrawlerCommand;
import schemacrawler.tools.options.OutputFormat;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.options.OutputOptionsBuilder;

public final class CommandChain
extends BaseCommandChain {
    private static final String COMMAND = "chain";

    public CommandChain(SchemaCrawlerCommand scCommand) throws SchemaCrawlerException {
        super(COMMAND);
        Objects.requireNonNull(scCommand, "No command provided, for settings");
        this.setSchemaCrawlerOptions(scCommand.getSchemaCrawlerOptions());
        this.setAdditionalConfiguration(scCommand.getAdditionalConfiguration());
        this.setOutputOptions(scCommand.getOutputOptions());
        this.setCatalog(scCommand.getCatalog());
        this.setConnection(scCommand.getConnection());
        this.setIdentifiers(scCommand.getIdentifiers());
    }

    public final SchemaCrawlerCommand addNext(String command, OutputFormat outputFormat, Path outputFile) throws SchemaCrawlerException {
        Objects.requireNonNull(command, "No command provided");
        Objects.requireNonNull(outputFormat, "No output format provided");
        Objects.requireNonNull(outputFile, "No output file provided");
        return this.addNext(command, outputFormat.getFormat(), outputFile.normalize().toAbsolutePath().toString());
    }

    public final SchemaCrawlerCommand addNext(String command, String outputFormat, String outputFileName) throws SchemaCrawlerException {
        Objects.requireNonNull(command, "No command provided");
        Objects.requireNonNull(outputFormat, "No output format provided");
        Objects.requireNonNull(outputFileName, "No output file name provided");
        Path outputFile = Paths.get(outputFileName, new String[0]);
        OutputOptions outputOptions = OutputOptionsBuilder.newOutputOptions(outputFormat, outputFile);
        return this.addNextAndConfigureForExecution(command, outputOptions);
    }

    @Override
    public void execute() throws Exception {
        this.checkCatalog();
        this.initializeChain();
        this.checkAvailibilityChain();
        this.executeChain();
    }

    @Override
    public boolean usesConnection() {
        return false;
    }
}

