/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline;

import java.nio.file.Path;
import java.nio.file.Paths;
import schemacrawler.schemacrawler.Config;
import schemacrawler.tools.commandline.BaseOptionsParser;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.options.OutputOptionsBuilder;
import sf.util.Utility;

public final class OutputOptionsParser
extends BaseOptionsParser<OutputOptions> {
    private static final String OUTPUT_FILE = "outputfile";
    private static final String OUTPUT_FORMAT = "outputformat";
    final OutputOptionsBuilder outputOptionsBuilder;

    public OutputOptionsParser(Config config) {
        super(config);
        this.normalizeOptionName(OUTPUT_FORMAT, "fmt");
        this.normalizeOptionName(OUTPUT_FILE, "o");
        this.outputOptionsBuilder = OutputOptionsBuilder.builder().fromConfig(config);
    }

    @Override
    public OutputOptions getOptions() {
        String outputFileName = this.config.getStringValue(OUTPUT_FILE, null);
        this.consumeOption(OUTPUT_FILE);
        if (!Utility.isBlank(outputFileName)) {
            Path outputFile = Paths.get(outputFileName, new String[0]).toAbsolutePath();
            this.outputOptionsBuilder.withOutputFile(outputFile);
        }
        String outputFormatValue = this.config.getStringValue(OUTPUT_FORMAT, null);
        this.consumeOption(OUTPUT_FORMAT);
        if (!Utility.isBlank(outputFormatValue)) {
            this.outputOptionsBuilder.withOutputFormatValue(outputFormatValue);
        }
        return this.outputOptionsBuilder.toOptions();
    }
}

