/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.util.logging.Level;
import schemacrawler.schemacrawler.SchemaInfoLevel;
import schemacrawler.schemacrawler.SchemaInfoLevelBuilder;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;

public enum InfoLevel {
    unknown(() -> SchemaInfoLevelBuilder.standard()),
    minimum(() -> SchemaInfoLevelBuilder.minimum()),
    standard(() -> SchemaInfoLevelBuilder.standard()),
    detailed(() -> SchemaInfoLevelBuilder.detailed()),
    maximum(() -> SchemaInfoLevelBuilder.maximum());

    private static final SchemaCrawlerLogger LOGGER;
    private final ToSchemaInfoLevelFunction toSchemaInfoLevelFunction;

    public static InfoLevel valueOfFromString(String infoLevelValue) {
        try {
            return InfoLevel.valueOf(infoLevelValue);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            LOGGER.log(Level.INFO, new StringFormat("Unknown infolevel <%s>", infoLevelValue));
            return unknown;
        }
    }

    private InfoLevel(ToSchemaInfoLevelFunction toSchemaInfoLevelFunction) {
        this.toSchemaInfoLevelFunction = toSchemaInfoLevelFunction;
    }

    public final SchemaInfoLevel toSchemaInfoLevel() {
        return this.toSchemaInfoLevelFunction.toSchemaInfoLevel();
    }

    static {
        LOGGER = SchemaCrawlerLogger.getLogger(InfoLevel.class.getName());
    }

    @FunctionalInterface
    private static interface ToSchemaInfoLevelFunction {
        public SchemaInfoLevel toSchemaInfoLevel();
    }
}

