/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import schemacrawler.crawl.AbstractProperty;
import schemacrawler.schema.DatabaseProperty;
import schemacrawler.schema.Property;

class ImmutableDatabaseProperty
extends AbstractProperty
implements DatabaseProperty {
    private static final long serialVersionUID = -7150431683440256142L;
    private static final Set<Map.Entry<String, String>> acronyms;

    ImmutableDatabaseProperty(String name, Object value) {
        super(name, (Serializable)value);
    }

    @Override
    public int compareTo(Property otherDbProperty) {
        if (otherDbProperty == null) {
            return -1;
        }
        return this.getDescription().toLowerCase().compareTo(otherDbProperty.getDescription().toLowerCase());
    }

    @Override
    public String getDescription() {
        String get = "get";
        String description = this.getName();
        if (description.startsWith("get")) {
            description = description.substring("get".length());
        }
        for (Map.Entry<String, String> acronym : acronyms) {
            description = description.replaceAll(acronym.getKey(), acronym.getValue());
        }
        int strLen = description.length();
        StringBuilder buffer = new StringBuilder(strLen);
        for (int i = 0; i < strLen; ++i) {
            char ch = description.charAt(i);
            if (Character.isUpperCase(ch) || Character.isTitleCase(ch)) {
                buffer.append(' ').append(Character.toLowerCase(ch));
                continue;
            }
            buffer.append(ch);
        }
        description = buffer.toString();
        for (Map.Entry<String, String> acronym : acronyms) {
            description = description.replaceAll(acronym.getValue().toLowerCase(), acronym.getKey());
            description = description.replaceAll(acronym.getValue(), acronym.getKey());
        }
        description = description.trim();
        return description;
    }

    public String toString() {
        return this.getDescription() + " = " + this.getValue();
    }

    static {
        HashMap<String, String> acronymsMap = new HashMap<String, String>();
        acronymsMap.put("JDBC", "Jdbc");
        acronymsMap.put("ANSI", "Ansi");
        acronymsMap.put("SQL", "Sql");
        acronymsMap.put("URL", "Url");
        acronymsMap.put("TYPE_FORWARD_ONLY", "Type_forward_only");
        acronymsMap.put("TYPE_SCROLL_INSENSITIVE", "Type_scroll_insensitive");
        acronymsMap.put("TYPE_SCROLL_SENSITIVE", "Type_scroll_sensitive");
        acronyms = Collections.unmodifiableSet(acronymsMap.entrySet());
    }
}

