/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import schemacrawler.crawl.AbstractDependantObject;
import schemacrawler.crawl.DatabaseObjectReference;
import schemacrawler.schema.BaseColumn;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.JavaSqlTypeGroup;
import schemacrawler.schema.NamedObject;

abstract class AbstractColumn<P extends DatabaseObject>
extends AbstractDependantObject<P>
implements BaseColumn<P> {
    private static final long serialVersionUID = -8492662324895309485L;
    private ColumnDataType columnDataType;
    private int ordinalPosition;
    private int size;
    private int decimalDigits;
    private boolean nullable;

    AbstractColumn(DatabaseObjectReference<P> parent, String name) {
        super(parent, name);
    }

    @Override
    public final int compareTo(NamedObject obj) {
        if (obj == null) {
            return -1;
        }
        BaseColumn other = (BaseColumn)obj;
        int comparison = 0;
        if (comparison == 0) {
            comparison = this.ordinalPosition - other.getOrdinalPosition();
        }
        if (comparison == 0) {
            comparison = super.compareTo(other);
        }
        return comparison;
    }

    @Override
    public final ColumnDataType getColumnDataType() {
        return this.columnDataType;
    }

    @Override
    public final int getDecimalDigits() {
        return this.decimalDigits;
    }

    @Override
    public final int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    @Override
    public final int getSize() {
        return this.size;
    }

    @Override
    public final ColumnDataType getType() {
        return this.getColumnDataType();
    }

    @Override
    public final String getWidth() {
        ColumnDataType columnDataType = this.getColumnDataType();
        if (columnDataType == null) {
            return "";
        }
        if (this.size <= 0 || this.size >= 2000000000) {
            return "";
        }
        JavaSqlTypeGroup sqlDataTypeGroup = columnDataType.getJavaSqlType().getJavaSqlTypeGroup();
        boolean needWidth = sqlDataTypeGroup == JavaSqlTypeGroup.character || sqlDataTypeGroup == JavaSqlTypeGroup.real;
        StringBuilder columnWidthBuffer = new StringBuilder(64);
        if (needWidth) {
            columnWidthBuffer.append('(');
            columnWidthBuffer.append(this.size);
            if (sqlDataTypeGroup == JavaSqlTypeGroup.real) {
                columnWidthBuffer.append(", ").append(this.getDecimalDigits());
            }
            columnWidthBuffer.append(')');
        }
        return columnWidthBuffer.toString();
    }

    @Override
    public final boolean isNullable() {
        return this.nullable;
    }

    final void setColumnDataType(ColumnDataType columnDataType) {
        this.columnDataType = columnDataType;
    }

    final void setDecimalDigits(int decimalDigits) {
        this.decimalDigits = decimalDigits;
    }

    final void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    final void setOrdinalPosition(int ordinalPosition) {
        this.ordinalPosition = ordinalPosition;
    }

    final void setSize(int size) {
        this.size = size;
    }
}

