/*
 * Decompiled with CFR 0.152.
 */
package uk.org.lidalia.test;

import java.lang.reflect.Array;
import java.util.Random;
import org.powermock.api.mockito.PowerMockito;

public final class Values {
    private static final Random RANDOM = new Random();

    public static <T> T uniqueValueFor(Class<T> aClass) {
        Object value;
        if (Values.isBoolean(aClass)) {
            value = RANDOM.nextBoolean();
        } else if (Values.isByte(aClass)) {
            value = (byte)RANDOM.nextInt();
        } else if (Values.isShort(aClass)) {
            value = (short)RANDOM.nextInt();
        } else if (Values.isChar(aClass)) {
            value = Character.valueOf((char)RANDOM.nextInt());
        } else if (Values.isInt(aClass)) {
            value = RANDOM.nextInt();
        } else if (Values.isLong(aClass)) {
            value = RANDOM.nextLong();
        } else if (Values.isFloat(aClass)) {
            value = Float.valueOf(RANDOM.nextFloat());
        } else if (Values.isDouble(aClass)) {
            value = RANDOM.nextDouble();
        } else if (aClass == String.class) {
            value = String.valueOf(RANDOM.nextLong());
        } else if (aClass.isArray()) {
            value = Array.newInstance(aClass.getComponentType(), 1);
            Array.set(value, 0, Values.uniqueValueFor(aClass.getComponentType()));
        } else {
            value = PowerMockito.mock(aClass);
        }
        return (T)value;
    }

    private static boolean isInt(Class<?> aClass) {
        return aClass == Integer.TYPE || aClass == Integer.class;
    }

    private static boolean isChar(Class<?> aClass) {
        return aClass == Character.TYPE || aClass == Character.class;
    }

    private static boolean isShort(Class<?> aClass) {
        return aClass == Short.TYPE || aClass == Short.class;
    }

    private static boolean isByte(Class<?> aClass) {
        return aClass == Byte.TYPE || aClass == Byte.class;
    }

    private static boolean isDouble(Class<?> aClass) {
        return aClass == Double.TYPE || aClass == Double.class;
    }

    private static boolean isFloat(Class<?> aClass) {
        return aClass == Float.TYPE || aClass == Float.class;
    }

    private static boolean isBoolean(Class<?> aClass) {
        return aClass == Boolean.TYPE || aClass == Boolean.class;
    }

    private static boolean isLong(Class<?> aClass) {
        return aClass == Long.TYPE || aClass == Long.class;
    }

    private Values() {
        throw new UnsupportedOperationException("Not instantiable");
    }
}

