/*
 * Decompiled with CFR 0.152.
 */
package uk.org.lidalia.test;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class SystemOutputRule
implements TestRule {
    private final ByteArrayOutputStream sysOut = new ByteArrayOutputStream();
    private final ByteArrayOutputStream sysErr = new ByteArrayOutputStream();
    private final PrintStream originalSysOut = System.out;
    private final PrintStream originalSysErr = System.err;

    public Statement apply(Statement base, Description description) {
        return new DebriefableSystemOutputsStatement(base, this.sysOut, this.sysErr, this.originalSysOut, this.originalSysErr);
    }

    public String getSystemOut() {
        return this.sysOut.toString();
    }

    public String getSystemErr() {
        return this.sysErr.toString();
    }

    private static class DebriefableSystemOutputsStatement
    extends Statement {
        private final Statement base;
        private final OutputStream sysOut;
        private final OutputStream sysErr;
        private final PrintStream originalSysOut;
        private final PrintStream originalSysErr;

        public DebriefableSystemOutputsStatement(Statement base, OutputStream sysOut, OutputStream sysErr, PrintStream originalSysOut, PrintStream originalSysErr) {
            this.base = base;
            this.sysOut = sysOut;
            this.sysErr = sysErr;
            this.originalSysOut = originalSysOut;
            this.originalSysErr = originalSysErr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void evaluate() throws Throwable {
            try {
                System.setOut(new PrintStream(this.sysOut));
                System.setErr(new PrintStream(this.sysErr));
                this.base.evaluate();
            }
            finally {
                System.setOut(this.originalSysOut);
                System.setErr(this.originalSysErr);
            }
        }
    }
}

