/*
 * Decompiled with CFR 0.152.
 */
package uk.org.lidalia.test;

import org.joda.time.DateTimeUtils;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class StaticTimeRule
implements TestRule {
    private final ReadableInstant instant;

    public static StaticTimeRule alwaysStartOfEpoch() {
        Instant startOfEpoch = new Instant(0L);
        return StaticTimeRule.always((ReadableInstant)startOfEpoch);
    }

    public static StaticTimeRule alwaysNow() {
        Instant now = new Instant();
        return StaticTimeRule.always((ReadableInstant)now);
    }

    public static StaticTimeRule always(ReadableInstant instant) {
        return new StaticTimeRule(instant);
    }

    private StaticTimeRule(ReadableInstant instant) {
        this.instant = instant;
    }

    public Statement apply(Statement base, Description description) {
        return new StaticTimeStatement(base, this.instant);
    }

    public ReadableInstant getInstant() {
        return this.instant;
    }

    private static class StaticTimeStatement
    extends Statement {
        private final Statement base;
        private final ReadableInstant instant;

        public StaticTimeStatement(Statement base, ReadableInstant instant) {
            this.base = base;
            this.instant = instant;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void evaluate() throws Throwable {
            try {
                DateTimeUtils.setCurrentMillisFixed((long)this.instant.getMillis());
                this.base.evaluate();
            }
            finally {
                DateTimeUtils.setCurrentMillisSystem();
            }
        }
    }
}

