/*
 * Decompiled with CFR 0.152.
 */
package uk.org.lidalia.test;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.hamcrest.internal.ReflectiveTypeFinder;

abstract class FeatureMatcher<T, U>
extends TypeSafeDiagnosingMatcher<T> {
    private static final ReflectiveTypeFinder TYPE_FINDER = new ReflectiveTypeFinder("featureValueOf", 1, 0);
    private final Matcher<? extends U> subMatcher;
    private final String featureDescription;
    private final String featureName;

    FeatureMatcher(Matcher<? extends U> subMatcher, String featureDescription, String featureName) {
        super(TYPE_FINDER);
        this.subMatcher = subMatcher;
        this.featureDescription = featureDescription;
        this.featureName = featureName;
    }

    protected abstract U featureValueOf(T var1);

    protected boolean matchesSafely(T actual, Description mismatch) {
        U featureValue = this.featureValueOf(actual);
        if (!this.subMatcher.matches(featureValue)) {
            mismatch.appendValue(actual).appendText(this.featureName).appendText(" ");
            this.subMatcher.describeMismatch(featureValue, mismatch);
            return false;
        }
        return true;
    }

    public final void describeTo(Description description) {
        description.appendText(this.featureDescription).appendText(" ").appendDescriptionOf(this.subMatcher);
    }
}

