/*
 * Decompiled with CFR 0.152.
 */
package uk.org.lidalia.test;

import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import uk.org.lidalia.test.AllOf;

class CombinableMatcher<T>
extends TypeSafeDiagnosingMatcher<T> {
    private final Matcher<? super T> matcher;

    CombinableMatcher(Matcher<? super T> matcher) {
        this.matcher = matcher;
    }

    protected boolean matchesSafely(T item, Description mismatch) {
        if (!this.matcher.matches(item)) {
            this.matcher.describeMismatch(item, mismatch);
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendDescriptionOf(this.matcher);
    }

    CombinableMatcher<T> and(Matcher<? super T> other) {
        return new CombinableMatcher<T>(new AllOf<T>(this.templatedListWith(other)));
    }

    private List<Matcher<? super T>> templatedListWith(Matcher<? super T> other) {
        ArrayList<Matcher<T>> matchers = new ArrayList<Matcher<T>>();
        matchers.add(this.matcher);
        matchers.add(other);
        return matchers;
    }

    @Factory
    static <LHS> CombinableMatcher<LHS> both(Matcher<? super LHS> matcher) {
        return new CombinableMatcher<LHS>(matcher);
    }
}

