/*
 * Decompiled with CFR 0.152.
 */
package uk.org.lidalia.test;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import uk.org.lidalia.lang.Exceptions;
import uk.org.lidalia.lang.Modifier;
import uk.org.lidalia.test.CombinableMatcher;
import uk.org.lidalia.test.FeatureMatcher;

public final class Assert {
    public static Matcher<Class<?>> isNotInstantiable() {
        return CombinableMatcher.both(Assert.aClassWhoseSuperClass(CoreMatchers.is((Matcher)CoreMatchers.equalTo(Object.class)))).and(Assert.aClassWhoseSetOfConstructors(CombinableMatcher.both(CoreMatchers.is(Assert.aCollectionWhoseSize((Matcher<Integer>)CoreMatchers.is((Object)1)))).and(CoreMatchers.is(Assert.aListWhoseElementAtIndex(0, CombinableMatcher.both(CoreMatchers.is(Assert.aConstructorWhoseParameterTypes(CoreMatchers.is(Assert.aCollectionWhoseSize((Matcher<Integer>)CoreMatchers.is((Object)0)))))).and(Assert.isAMemberWithModifier(Modifier.PRIVATE)).and(Assert.aConstructorWhoseThrownException(CombinableMatcher.both(CoreMatchers.isA(UnsupportedOperationException.class)).and(CoreMatchers.is(Assert.aThrowableWhoseMessage((Matcher<String>)CoreMatchers.is((Object)"Not instantiable")))))))))));
    }

    public static <U, T extends U> FeatureMatcher<Class<? extends T>, Class<? extends U>> aClassWhoseSuperClass(Matcher<? extends Class<? extends U>> classMatcher) {
        return new FeatureMatcher<Class<? extends T>, Class<? extends U>>((Matcher)classMatcher, "a Class whose super class", "'s super class"){

            @Override
            protected Class<? extends U> featureValueOf(Class<? extends T> actual) {
                return actual.getSuperclass();
            }
        };
    }

    private static FeatureMatcher<Class<?>, List<Constructor<?>>> aClassWhoseSetOfConstructors(Matcher<List<Constructor<?>>> matcher) {
        return new FeatureMatcher<Class<?>, List<Constructor<?>>>((Matcher)matcher, "a Class whose set of constructors", "'s constructors"){

            @Override
            protected List<Constructor<?>> featureValueOf(Class<?> actual) {
                List<Constructor<?>> constructors = Arrays.asList(actual.getDeclaredConstructors());
                Collections.sort(constructors, new Comparator<Constructor<?>>(){

                    @Override
                    public int compare(Constructor<?> one, Constructor<?> other) {
                        return one.toString().compareTo(other.toString());
                    }
                });
                return constructors;
            }
        };
    }

    public static <T extends Collection<?>> Matcher<T> aCollectionWhoseSize(Matcher<Integer> sizeMatcher) {
        return new FeatureMatcher<T, Integer>((Matcher)sizeMatcher, "a Collection whose size", "'s length"){

            @Override
            protected Integer featureValueOf(T actual) {
                return actual.size();
            }
        };
    }

    public static <T extends List<? extends E>, E> Matcher<T> aListWhoseElementAtIndex(final Integer index, Matcher<E> matcher) {
        return new FeatureMatcher<T, E>(matcher, "a List whose element at index " + index, "'s element at index " + index){

            @Override
            protected E featureValueOf(T actual) {
                if (actual.size() > index) {
                    return actual.get(index);
                }
                throw new AssertionError((Object)(actual + " has no element at index " + index));
            }
        };
    }

    public static <T extends Member> Matcher<T> isAMemberWithModifier(final Modifier modifier) {
        return new TypeSafeDiagnosingMatcher<T>(){

            protected boolean matchesSafely(T item, Description mismatchDescription) {
                boolean matches = modifier.existsOn(item);
                if (!matches) {
                    mismatchDescription.appendValue(item).appendText(" did not have modifier ").appendValue((Object)modifier);
                }
                return matches;
            }

            public void describeTo(Description description) {
                description.appendText("is a member with modifier " + modifier);
            }
        };
    }

    private static Matcher<Constructor<?>> aConstructorWhoseParameterTypes(Matcher<List<Class<?>>> parameterMatcher) {
        return new FeatureMatcher<Constructor<?>, List<Class<?>>>((Matcher)parameterMatcher, "a constructor whose parameter types", "'s parameter types"){

            @Override
            protected List<Class<?>> featureValueOf(Constructor<?> actual) {
                return Arrays.asList(actual.getParameterTypes());
            }
        };
    }

    private static Matcher<Constructor<?>> aConstructorWhoseThrownException(Matcher<? extends Throwable> throwableMatcher) {
        return new FeatureMatcher<Constructor<?>, Throwable>((Matcher)throwableMatcher, "a constructor whose thrown exception", "'s thrown exception"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Throwable featureValueOf(Constructor<?> constructor) {
                try {
                    constructor.setAccessible(true);
                    constructor.newInstance(new Object[0]);
                    Throwable throwable = null;
                    return throwable;
                }
                catch (InvocationTargetException e) {
                    Throwable throwable = e.getCause();
                    return throwable;
                }
                catch (Exception e) {
                    Throwable throwable = (Throwable)Exceptions.throwUnchecked((Throwable)e, null);
                    return throwable;
                }
                finally {
                    constructor.setAccessible(false);
                }
            }
        };
    }

    private static Matcher<Throwable> aThrowableWhoseMessage(Matcher<String> messageMatcher) {
        return new FeatureMatcher<Throwable, String>(messageMatcher, "a throwable whose message", "'s message"){

            @Override
            protected String featureValueOf(Throwable actual) {
                return actual.getMessage();
            }
        };
    }

    private Assert() {
        throw new UnsupportedOperationException("Not instantiable");
    }
}

