/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.threetier;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.toplink.essentials.exceptions.ConcurrencyException;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.databaseaccess.Accessor;
import oracle.toplink.essentials.internal.sequencing.SequencingCallback;
import oracle.toplink.essentials.internal.sequencing.SequencingServer;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.DatabaseSessionImpl;
import oracle.toplink.essentials.internal.sessions.IsolatedClientSession;
import oracle.toplink.essentials.queryframework.Call;
import oracle.toplink.essentials.queryframework.DatabaseQuery;
import oracle.toplink.essentials.sessions.DatasourceLogin;
import oracle.toplink.essentials.sessions.Login;
import oracle.toplink.essentials.sessions.Project;
import oracle.toplink.essentials.sessions.UnitOfWork;
import oracle.toplink.essentials.threetier.ClientSession;
import oracle.toplink.essentials.threetier.ConnectionPolicy;
import oracle.toplink.essentials.threetier.ConnectionPool;
import oracle.toplink.essentials.threetier.ExternalConnectionPool;
import oracle.toplink.essentials.threetier.ReadConnectionPool;
import oracle.toplink.essentials.threetier.Server;

public class ServerSession
extends DatabaseSessionImpl
implements Server {
    protected ConnectionPool readConnectionPool;
    protected Map connectionPools = new HashMap(10);
    protected ConnectionPolicy defaultConnectionPolicy;
    protected int maxNumberOfNonPooledConnections;
    protected int numberOfNonPooledConnectionsUsed;
    public static final int MAX_WRITE_CONNECTIONS = 10;
    public static final int MIN_WRITE_CONNECTIONS = 5;

    public ServerSession() {
    }

    public ServerSession(Login login) {
        this(new Project(login));
    }

    public ServerSession(Login login, int minNumberOfPooledConnection, int maxNumberOfPooledConnection) {
        this(new Project(login), minNumberOfPooledConnection, maxNumberOfPooledConnection);
    }

    public ServerSession(Login login, ConnectionPolicy defaultConnectionPolicy) {
        this(new Project(login), defaultConnectionPolicy);
    }

    public ServerSession(Project project) {
        this(project, 5, 10);
    }

    public ServerSession(Project project, int minNumberOfPooledConnection, int maxNumberOfPooledConnection) {
        this(project, new ConnectionPolicy("default"));
        ConnectionPool pool = null;
        pool = project.getDatasourceLogin().shouldUseExternalConnectionPooling() ? new ExternalConnectionPool("default", project.getDatasourceLogin(), this) : new ConnectionPool("default", project.getDatasourceLogin(), minNumberOfPooledConnection, maxNumberOfPooledConnection, this);
        this.connectionPools.put("default", pool);
    }

    public ServerSession(Project project, int minNumberOfPooledConnection, int maxNumberOfPooledConnection, Login readLogin) {
        this(project, new ConnectionPolicy("default"), readLogin);
        ConnectionPool pool = null;
        pool = project.getDatasourceLogin().shouldUseExternalConnectionPooling() ? new ExternalConnectionPool("default", project.getDatasourceLogin(), this) : new ConnectionPool("default", project.getDatasourceLogin(), minNumberOfPooledConnection, maxNumberOfPooledConnection, this);
        this.connectionPools.put("default", pool);
    }

    public ServerSession(Project project, int minNumberOfPooledConnection, int maxNumberOfPooledConnection, Login readLogin, Login sequenceLogin) {
        this(project, new ConnectionPolicy("default"), readLogin, sequenceLogin);
        ConnectionPool pool = null;
        pool = project.getDatasourceLogin().shouldUseExternalConnectionPooling() ? new ExternalConnectionPool("default", project.getDatasourceLogin(), this) : new ConnectionPool("default", project.getDatasourceLogin(), minNumberOfPooledConnection, maxNumberOfPooledConnection, this);
        this.connectionPools.put("default", pool);
    }

    public ServerSession(Project project, ConnectionPolicy defaultConnectionPolicy) {
        super(project);
        this.defaultConnectionPolicy = defaultConnectionPolicy;
        this.maxNumberOfNonPooledConnections = 50;
        this.numberOfNonPooledConnectionsUsed = 0;
        this.setReadConnectionPool(project.getDatasourceLogin());
    }

    public ServerSession(Project project, ConnectionPolicy defaultConnectionPolicy, Login readLogin) {
        super(project);
        this.defaultConnectionPolicy = defaultConnectionPolicy;
        this.maxNumberOfNonPooledConnections = 50;
        this.numberOfNonPooledConnectionsUsed = 0;
        Login login = readLogin != null ? readLogin : project.getDatasourceLogin();
        this.setReadConnectionPool(login);
    }

    public ServerSession(Project project, ConnectionPolicy defaultConnectionPolicy, Login readLogin, Login sequenceLogin) {
        this(project, defaultConnectionPolicy, readLogin);
        if (sequenceLogin != null) {
            this.getSequencingControl().setShouldUseSeparateConnection(true);
            this.getSequencingControl().setLogin(sequenceLogin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireClientConnection(ClientSession clientSession) throws DatabaseException, ConcurrencyException {
        if (clientSession.getConnectionPolicy().isPooled()) {
            ConnectionPool pool = (ConnectionPool)this.getConnectionPools().get(clientSession.getConnectionPolicy().getPoolName());
            Accessor connection = pool.acquireConnection();
            clientSession.setWriteConnection(connection);
            this.getEventManager().postAcquireConnection(connection);
        } else {
            ServerSession serverSession = this;
            synchronized (serverSession) {
                while (this.getNumberOfNonPooledConnectionsUsed() >= this.getMaxNumberOfNonPooledConnections()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException exception) {
                        throw ConcurrencyException.waitFailureOnServerSession(exception);
                    }
                }
                this.setNumberOfNonPooledConnectionsUsed(this.getNumberOfNonPooledConnectionsUsed() + 1);
                clientSession.setWriteConnection(clientSession.getLogin().buildAccessor());
                clientSession.connect();
            }
        }
    }

    public ClientSession acquireClientSession() throws DatabaseException {
        return this.acquireClientSession((ConnectionPolicy)this.getDefaultConnectionPolicy().clone());
    }

    public ClientSession acquireClientSession(String poolName) throws DatabaseException {
        return this.acquireClientSession(new ConnectionPolicy(poolName));
    }

    public ClientSession acquireClientSession(Login login) throws DatabaseException {
        return this.acquireClientSession(new ConnectionPolicy(login));
    }

    public ClientSession acquireClientSession(ConnectionPolicy connectionPolicy) throws DatabaseException, ValidationException {
        if (!this.isConnected()) {
            throw ValidationException.loginBeforeAllocatingClientSessions();
        }
        this.log(2, "connection", "client_acquired");
        if (!connectionPolicy.isPooled() && connectionPolicy.getLogin() == null) {
            connectionPolicy.setPoolName(this.getDefaultConnectionPolicy().getPoolName());
            connectionPolicy.setLogin(this.getDefaultConnectionPolicy().getLogin());
        }
        if (connectionPolicy.isPooled()) {
            ConnectionPool pool = (ConnectionPool)this.getConnectionPools().get(connectionPolicy.getPoolName());
            if (pool == null) {
                throw ValidationException.poolNameDoesNotExist(connectionPolicy.getPoolName());
            }
            connectionPolicy.setLogin((Login)pool.getLogin().clone());
        }
        ClientSession client = null;
        client = this.getProject().hasIsolatedClasses() ? new IsolatedClientSession(this, connectionPolicy) : new ClientSession(this, connectionPolicy);
        if (!connectionPolicy.isLazy()) {
            this.acquireClientConnection(client);
        }
        return client;
    }

    public UnitOfWork acquireUnitOfWork() {
        return this.acquireClientSession().acquireUnitOfWork();
    }

    public void addConnectionPool(String poolName, Login login, int minNumberOfConnections, int maxNumberOfConnections) throws ValidationException {
        if (minNumberOfConnections > maxNumberOfConnections) {
            throw ValidationException.maxSizeLessThanMinSize();
        }
        if (this.isConnected()) {
            throw ValidationException.poolsMustBeConfiguredBeforeLogin();
        }
        ConnectionPool pool = null;
        pool = login.shouldUseExternalConnectionPooling() ? new ExternalConnectionPool(poolName, login, this) : new ConnectionPool(poolName, login, minNumberOfConnections, maxNumberOfConnections, this);
        this.addConnectionPool(pool);
    }

    public void addConnectionPool(ConnectionPool pool) {
        pool.setOwner(this);
        this.getConnectionPools().put(pool.getName(), pool);
    }

    public void afterTransaction(boolean committed, boolean isExternalTransaction, Accessor accessor) {
        SequencingCallback callback = this.getSequencingHome().getSequencingCallback();
        if (callback != null) {
            callback.afterTransaction(accessor, committed);
        }
    }

    public Accessor allocateReadConnection() {
        Accessor connection = this.getReadConnectionPool().acquireConnection();
        this.getEventManager().postAcquireConnection(connection);
        return connection;
    }

    public void connect(boolean updatePlatform) {
        this.updateStandardConnectionPools();
        if (updatePlatform) {
            Iterator pools = this.getConnectionPools().values().iterator();
            while (pools.hasNext()) {
                ((DatasourceLogin)((ConnectionPool)pools.next()).getLogin()).usePlatform(this.getDatasourceLogin().getDatasourcePlatform());
            }
            ((DatasourceLogin)this.getReadConnectionPool().getLogin()).usePlatform(this.getDatasourceLogin().getDatasourcePlatform());
        }
        this.getReadConnectionPool().startUp();
        this.setAccessor(this.allocateReadConnection());
        this.releaseReadConnection(this.getAccessor());
        Iterator poolsEnum = this.getConnectionPools().values().iterator();
        while (poolsEnum.hasNext()) {
            ((ConnectionPool)poolsEnum.next()).startUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeCall(Call call, AbstractRecord translationRow, DatabaseQuery query) throws DatabaseException {
        Object object;
        block14: {
            RuntimeException exception = null;
            object = null;
            boolean accessorAllocated = false;
            if (query.getAccessor() == null) {
                query.setAccessor(this.allocateReadConnection());
                accessorAllocated = true;
            }
            try {
                object = query.getAccessor().executeCall(call, translationRow, this);
            }
            catch (RuntimeException caughtException) {
                exception = caughtException;
                return exception;
            }
            finally {
                block15: {
                    if (call.isFinished()) {
                        try {
                            if (accessorAllocated) {
                                this.releaseReadConnection(query.getAccessor());
                                query.setAccessor(null);
                            }
                        }
                        catch (RuntimeException releaseException) {
                            if (exception != null) break block15;
                            throw releaseException;
                        }
                    }
                }
                if (exception == null) break block14;
                throw exception;
            }
        }
        return object;
    }

    public ConnectionPool getConnectionPool(String poolName) {
        return (ConnectionPool)this.getConnectionPools().get(poolName);
    }

    public Map getConnectionPools() {
        return this.connectionPools;
    }

    public ConnectionPolicy getDefaultConnectionPolicy() {
        if (this.defaultConnectionPolicy == null) {
            this.defaultConnectionPolicy = new ConnectionPolicy("default");
        }
        return this.defaultConnectionPolicy;
    }

    public ConnectionPool getDefaultConnectionPool() {
        return this.getConnectionPool("default");
    }

    public AbstractSession getExecutionSession(DatabaseQuery query) {
        if (query.isObjectLevelModifyQuery()) {
            throw QueryException.invalidQueryOnServerSession(query);
        }
        return this;
    }

    public int getMaxNumberOfNonPooledConnections() {
        return this.maxNumberOfNonPooledConnections;
    }

    public int getNumberOfNonPooledConnectionsUsed() {
        return this.numberOfNonPooledConnectionsUsed;
    }

    protected Login getReadLogin() {
        return this.getReadConnectionPool().getLogin();
    }

    public ConnectionPool getReadConnectionPool() {
        return this.readConnectionPool;
    }

    public boolean isConnected() {
        if (this.getReadConnectionPool() == null) {
            return false;
        }
        return this.getReadConnectionPool().isConnected();
    }

    public boolean isServerSession() {
        return true;
    }

    public void logout() {
        super.logout();
        this.getReadConnectionPool().shutDown();
        Iterator poolsEnum = this.getConnectionPools().values().iterator();
        while (poolsEnum.hasNext()) {
            ((ConnectionPool)poolsEnum.next()).shutDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseClientSession(ClientSession clientSession) throws DatabaseException {
        if (clientSession.getConnectionPolicy().isPooled()) {
            ConnectionPool pool = (ConnectionPool)this.getConnectionPools().get(clientSession.getConnectionPolicy().getPoolName());
            this.getEventManager().preReleaseConnection(clientSession.getWriteConnection());
            pool.releaseConnection(clientSession.getWriteConnection());
            clientSession.setWriteConnection(null);
        } else {
            ServerSession serverSession = this;
            synchronized (serverSession) {
                clientSession.disconnect();
                clientSession.setWriteConnection(null);
                this.setNumberOfNonPooledConnectionsUsed(this.getNumberOfNonPooledConnectionsUsed() - 1);
                this.notify();
            }
        }
    }

    public void releaseReadConnection(Accessor connection) {
        this.getEventManager().preReleaseConnection(connection);
        this.getReadConnectionPool().releaseConnection(connection);
    }

    public void setConnectionPools(Map connectionPools) {
        this.connectionPools = connectionPools;
    }

    public void setDefaultConnectionPolicy(ConnectionPolicy defaultConnectionPolicy) {
        this.defaultConnectionPolicy = defaultConnectionPolicy;
    }

    public void setDefaultConnectionPool() {
        this.addConnectionPool("default", this.getDatasourceLogin(), 5, 10);
    }

    public void setMaxNumberOfNonPooledConnections(int maxNumberOfNonPooledConnections) {
        this.maxNumberOfNonPooledConnections = maxNumberOfNonPooledConnections;
    }

    public void setNumberOfNonPooledConnectionsUsed(int numberOfNonPooledConnectionsUsed) {
        this.numberOfNonPooledConnectionsUsed = numberOfNonPooledConnectionsUsed;
    }

    public void setReadConnectionPool(ConnectionPool readConnectionPool) {
        if (this.isConnected()) {
            throw ValidationException.cannotSetReadPoolSizeAfterLogin();
        }
        this.readConnectionPool = readConnectionPool;
        this.readConnectionPool.setOwner(this);
    }

    public void setReadConnectionPool(Login readLogin) throws ValidationException {
        if (this.isConnected()) {
            throw ValidationException.poolsMustBeConfiguredBeforeLogin();
        }
        ConnectionPool pool = null;
        pool = readLogin.shouldUseExternalConnectionPooling() ? new ExternalConnectionPool("read", readLogin, this) : new ConnectionPool("read", readLogin, 2, 2, this);
        this.readConnectionPool = pool;
    }

    protected void updateStandardConnectionPools() {
        if (this.getDefaultConnectionPool() != null && this.getDefaultConnectionPool().isThereConflictBetweenLoginAndType()) {
            this.setDefaultConnectionPool();
        }
        if (this.getReadConnectionPool() != null && this.getReadConnectionPool().isThereConflictBetweenLoginAndType()) {
            this.setReadConnectionPool(this.getReadConnectionPool().getLogin());
        }
    }

    public void useExclusiveReadConnectionPool(int minNumerOfConnections, int maxNumerOfConnections) {
        this.setReadConnectionPool(new ConnectionPool("read", this.getDatasourceLogin(), minNumerOfConnections, maxNumerOfConnections, this));
    }

    public void useExternalReadConnectionPool() {
        this.setReadConnectionPool(new ExternalConnectionPool("read", this.getDatasourceLogin(), this));
    }

    public void useReadConnectionPool(int minNumerOfConnections, int maxNumerOfConnections) {
        this.setReadConnectionPool(new ReadConnectionPool("read", this.getDatasourceLogin(), minNumerOfConnections, maxNumerOfConnections, this));
    }

    public SequencingServer getSequencingServer() {
        return this.getSequencingHome().getSequencingServer();
    }
}

