/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.sessions;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.exceptions.IntegrityException;
import oracle.toplink.essentials.exceptions.OptimisticLockException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.helper.DBPlatformHelper;
import oracle.toplink.essentials.internal.sequencing.Sequencing;
import oracle.toplink.essentials.internal.sequencing.SequencingCallback;
import oracle.toplink.essentials.internal.sequencing.SequencingFactory;
import oracle.toplink.essentials.internal.sequencing.SequencingHome;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.platform.server.NoServerPlatform;
import oracle.toplink.essentials.platform.server.ServerPlatform;
import oracle.toplink.essentials.sequencing.SequencingControl;
import oracle.toplink.essentials.sessions.DatabaseSession;
import oracle.toplink.essentials.sessions.DatasourceLogin;
import oracle.toplink.essentials.sessions.Login;
import oracle.toplink.essentials.sessions.Project;

public class DatabaseSessionImpl
extends AbstractSession
implements DatabaseSession {
    private SequencingHome sequencingHome;
    private ServerPlatform serverPlatform;
    private long connectedTime;
    protected boolean isLoggedIn;

    protected void setSequencingHome(SequencingHome sequencingHome) {
        this.sequencingHome = sequencingHome;
    }

    protected SequencingHome getSequencingHome() {
        if (this.sequencingHome == null) {
            this.setSequencingHome(SequencingFactory.createSequencingHome(this));
        }
        return this.sequencingHome;
    }

    public SequencingControl getSequencingControl() {
        return this.getSequencingHome().getSequencingControl();
    }

    public Sequencing getSequencing() {
        return this.getSequencingHome().getSequencing();
    }

    public void initializeSequencing() {
        this.getSequencingHome().onDisconnect();
        this.getSequencingHome().onConnect();
    }

    public void afterTransaction(boolean committed, boolean isExternalTransaction) {
        SequencingCallback callback = this.getSequencingHome().getSequencingCallback();
        if (callback != null) {
            callback.afterTransaction(this.getAccessor(), committed);
        }
    }

    public DatabaseSessionImpl() {
        this.setServerPlatform(new NoServerPlatform(this));
    }

    public DatabaseSessionImpl(Login login) {
        this(new Project(login));
    }

    public DatabaseSessionImpl(Project project) {
        super(project);
        this.setServerPlatform(new NoServerPlatform(this));
    }

    public void addDescriptor(ClassDescriptor descriptor) {
        this.lastDescriptorAccessed = null;
        this.getProject().addDescriptor(descriptor, this);
    }

    public void addDescriptors(Vector descriptors) {
        this.lastDescriptorAccessed = null;
        this.getProject().addDescriptors(descriptors, this);
    }

    public void addDescriptors(Project project) {
        this.lastDescriptorAccessed = null;
        this.getProject().addDescriptors(project, this);
    }

    public void connect() throws DatabaseException {
        this.connect(false);
    }

    public void connect(boolean updatePlatform) throws DatabaseException {
        this.getAccessor().connect(this.getDatasourceLogin(), this);
    }

    public void disconnect() throws DatabaseException {
        this.getSequencingHome().onDisconnect();
        this.getAccessor().disconnect(this);
    }

    public ServerPlatform getServerPlatform() {
        return this.serverPlatform;
    }

    public void setServerPlatform(ServerPlatform newServerPlatform) {
        if (this.isConnected()) {
            throw ValidationException.serverPlatformIsReadOnlyAfterLogin(newServerPlatform.getClass().getName());
        }
        this.serverPlatform = newServerPlatform;
    }

    protected void finalize() throws DatabaseException {
        if (this.isConnected()) {
            this.logout();
        }
    }

    public Map getDescriptors() {
        return this.getProject().getDescriptors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeDescriptorIfSessionAlive(ClassDescriptor descriptor) {
        if (this.isConnected() && descriptor.requiresInitialization()) {
            try {
                try {
                    descriptor.preInitialize(this);
                    descriptor.initialize(this);
                    descriptor.postInitialize(this);
                    this.getCommitManager().initializeCommitOrder();
                }
                catch (RuntimeException exception) {
                    this.getIntegrityChecker().handleError(exception);
                }
                if (this.getIntegrityChecker().hasErrors()) {
                    this.handleException(new IntegrityException(this.getIntegrityChecker()));
                }
            }
            finally {
                this.clearIntegrityChecker();
            }
        }
    }

    public void initializeDescriptors() {
        this.getProject().setIsPureCMP2Project(true);
        this.initializeDescriptors((Map)((HashMap)this.getDescriptors()).clone());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeDescriptors(Map descriptors) {
        this.initializeSequencing();
        try {
            AbstractSession session;
            for (ClassDescriptor descriptor : descriptors.values()) {
                try {
                    session = this.getSessionForClass(descriptor.getJavaClass());
                    if (descriptor.requiresInitialization()) {
                        descriptor.preInitialize(session);
                    }
                    if (!descriptor.isAggregateDescriptor() || !descriptor.isChildDescriptor()) continue;
                    descriptor.initializeAggregateInheritancePolicy(session);
                }
                catch (RuntimeException exception) {
                    this.getIntegrityChecker().handleError(exception);
                }
            }
            for (ClassDescriptor descriptor : descriptors.values()) {
                try {
                    session = this.getSessionForClass(descriptor.getJavaClass());
                    if (!descriptor.requiresInitialization()) continue;
                    descriptor.initialize(session);
                }
                catch (RuntimeException exception) {
                    this.getIntegrityChecker().handleError(exception);
                }
            }
            for (ClassDescriptor descriptor : descriptors.values()) {
                try {
                    session = this.getSessionForClass(descriptor.getJavaClass());
                    if (!descriptor.requiresInitialization()) continue;
                    descriptor.postInitialize(session);
                }
                catch (RuntimeException exception) {
                    this.getIntegrityChecker().handleError(exception);
                }
            }
            try {
                this.getCommitManager().initializeCommitOrder();
            }
            catch (RuntimeException exception) {
                this.getIntegrityChecker().handleError(exception);
            }
            if (this.getIntegrityChecker().hasErrors()) {
                this.handleSevere(new IntegrityException(this.getIntegrityChecker()));
            }
        }
        finally {
            this.clearIntegrityChecker();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeDescriptors(Vector descriptors) {
        this.initializeSequencing();
        try {
            AbstractSession session;
            ClassDescriptor descriptor;
            Enumeration descriptorEnum = descriptors.elements();
            while (descriptorEnum.hasMoreElements()) {
                try {
                    descriptor = (ClassDescriptor)descriptorEnum.nextElement();
                    session = this.getSessionForClass(descriptor.getJavaClass());
                    if (descriptor.requiresInitialization()) {
                        descriptor.preInitialize(session);
                    }
                    if (!descriptor.isAggregateDescriptor() || !descriptor.isChildDescriptor()) continue;
                    descriptor.initializeAggregateInheritancePolicy(session);
                }
                catch (RuntimeException exception) {
                    this.getIntegrityChecker().handleError(exception);
                }
            }
            descriptorEnum = descriptors.elements();
            while (descriptorEnum.hasMoreElements()) {
                try {
                    descriptor = (ClassDescriptor)descriptorEnum.nextElement();
                    session = this.getSessionForClass(descriptor.getJavaClass());
                    if (!descriptor.requiresInitialization()) continue;
                    descriptor.initialize(session);
                }
                catch (RuntimeException exception) {
                    this.getIntegrityChecker().handleError(exception);
                }
            }
            descriptorEnum = descriptors.elements();
            while (descriptorEnum.hasMoreElements()) {
                try {
                    descriptor = (ClassDescriptor)descriptorEnum.nextElement();
                    session = this.getSessionForClass(descriptor.getJavaClass());
                    if (!descriptor.requiresInitialization()) continue;
                    descriptor.postInitialize(session);
                }
                catch (RuntimeException exception) {
                    this.getIntegrityChecker().handleError(exception);
                }
            }
            try {
                this.getCommitManager().initializeCommitOrder();
            }
            catch (RuntimeException exception) {
                this.getIntegrityChecker().handleError(exception);
            }
            if (this.getIntegrityChecker().hasErrors()) {
                this.handleException(new IntegrityException(this.getIntegrityChecker()));
            }
        }
        finally {
            this.clearIntegrityChecker();
        }
    }

    public boolean isDatabaseSession() {
        return true;
    }

    protected Login getReadLogin() {
        return this.getDatasourceLogin();
    }

    public void loginAndDetectDatasource() throws DatabaseException {
        this.preConnectDatasource();
        Connection conn = null;
        try {
            conn = (Connection)this.getReadLogin().connectToDatasource(null);
            this.getLogin().setPlatformClassName(DBPlatformHelper.getDBPlatform(conn.getMetaData().getDatabaseProductName(), this.getSessionLog()));
        }
        catch (SQLException ex) {
            DatabaseException dbEx = DatabaseException.errorRetrieveDbMetadataThroughJDBCConnection();
            dbEx.initCause(ex);
            throw dbEx;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {
                    DatabaseException dbEx = DatabaseException.errorRetrieveDbMetadataThroughJDBCConnection();
                    dbEx.initCause(ex);
                    throw dbEx;
                }
            }
        }
        this.connect(true);
        this.postConnectDatasource();
    }

    public void login() throws DatabaseException {
        this.preConnectDatasource();
        this.connect(false);
        this.postConnectDatasource();
    }

    public void login(String userName, String password) throws DatabaseException {
        this.getDatasourceLogin().setUserName(userName);
        this.getDatasourceLogin().setPassword(password);
        this.login();
    }

    public void login(Login login) throws DatabaseException {
        this.setLogin(login);
        this.login();
    }

    public void logout() throws DatabaseException {
        this.lastDescriptorAccessed = null;
        if (this.isInTransaction()) {
            throw DatabaseException.logoutWhileTransactionInProgress();
        }
        if (this.getAccessor() == null) {
            return;
        }
        this.disconnect();
        this.getIdentityMapAccessor().initializeIdentityMaps();
        this.isLoggedIn = false;
        this.log(5, null, "logout_successful", this.getName());
        this.getServerPlatform().unregisterMBean();
    }

    public void initializeConnectedTime() {
        this.connectedTime = System.currentTimeMillis();
    }

    public long getConnectedTime() {
        return this.connectedTime;
    }

    protected void preConnectDatasource() {
        if (this.isLoggedIn) {
            throw ValidationException.alreadyLoggedIn(this.getName());
        }
        this.platform = null;
        if (this.isInProfile()) {
            this.getProfiler().initialize();
        }
        this.updateProfile("loginTime", new Date(System.currentTimeMillis()));
        this.getEventManager().preLogin(this);
        this.getServerPlatform().initializeExternalTransactionController();
        this.log(5, null, "topLink_version", DatasourceLogin.getVersion());
        if (this.getServerPlatform().getServerNameAndVersion() != null) {
            this.log(5, null, "application_server_name_and_version", this.getServerPlatform().getServerNameAndVersion());
        }
    }

    protected void postConnectDatasource() {
        this.initializeDescriptors();
        this.processEJBQLQueries();
        this.log(5, null, "login_successful", this.getName());
        this.getEventManager().postLogin(this);
        this.initializeConnectedTime();
        this.isLoggedIn = true;
        this.platform = null;
        this.getServerPlatform().registerMBean();
    }

    public void writeAllObjects(Collection domainObjects) throws DatabaseException, OptimisticLockException {
        Iterator objectsEnum = domainObjects.iterator();
        while (objectsEnum.hasNext()) {
            this.writeObject(objectsEnum.next());
        }
    }

    public void writeAllObjects(Vector domainObjects) throws DatabaseException, OptimisticLockException {
        Enumeration objectsEnum = domainObjects.elements();
        while (objectsEnum.hasMoreElements()) {
            this.writeObject(objectsEnum.nextElement());
        }
    }
}

