/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.parsing;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.internal.helper.BasicTypeHelperImpl;
import oracle.toplink.essentials.internal.parsing.TypeHelper;
import oracle.toplink.essentials.internal.security.PrivilegedAccessHelper;
import oracle.toplink.essentials.internal.security.PrivilegedClassForName;
import oracle.toplink.essentials.internal.security.PrivilegedGetField;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.mappings.AggregateMapping;
import oracle.toplink.essentials.mappings.DatabaseMapping;

public class TypeHelperImpl
extends BasicTypeHelperImpl
implements TypeHelper {
    private final AbstractSession session;
    private final ClassLoader classLoader;

    public TypeHelperImpl(AbstractSession session, ClassLoader classLoader) {
        this.session = session;
        this.classLoader = classLoader;
    }

    public String getTypeName(Object type) {
        if (type == null) {
            return null;
        }
        return ((Class)type).getName();
    }

    public Object resolveTypeName(String typeName) {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return (Class)AccessController.doPrivileged(new PrivilegedClassForName(typeName, true, this.classLoader));
                }
                catch (PrivilegedActionException exception) {
                    return null;
                }
            }
            return PrivilegedAccessHelper.getClassForName(typeName, true, this.classLoader);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    public Object resolveAttribute(Object ownerClass, String attribute) {
        Class clazz = (Class)ownerClass;
        DatabaseMapping mapping = this.resolveAttributeMapping(ownerClass, attribute);
        Class<?> type = this.getType(mapping);
        if (type == null && mapping != null) {
            Field field = null;
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        field = (Field)AccessController.doPrivileged(new PrivilegedGetField(clazz, attribute, true));
                    }
                    catch (PrivilegedActionException exception) {}
                } else {
                    field = PrivilegedAccessHelper.getField(clazz, attribute, true);
                }
                if (field != null) {
                    type = field.getType();
                }
            }
            catch (NoSuchFieldException ex) {
                // empty catch block
            }
        }
        return type;
    }

    public Object resolveSchema(String schemaName) {
        ClassDescriptor descriptor = this.session.getDescriptorForAlias(schemaName);
        return descriptor != null ? descriptor.getJavaClass() : null;
    }

    public Object resolveEnumConstant(Object type, String constant) {
        Class clazz = (Class)type;
        T[] constants = clazz.getEnumConstants();
        if (constants != null) {
            for (int i = 0; i < constants.length; ++i) {
                if (!constant.equals(constants[i].toString())) continue;
                return constants[i];
            }
        }
        return null;
    }

    public boolean isEntityClass(Object type) {
        ClassDescriptor desc = this.getDescriptor(type);
        return desc != null && !desc.isAggregateDescriptor();
    }

    public boolean isEmbeddable(Object type) {
        ClassDescriptor desc = this.getDescriptor(type);
        return desc != null && desc.isAggregateDescriptor();
    }

    public boolean isEmbeddedAttribute(Object ownerClass, String attribute) {
        DatabaseMapping mapping = this.resolveAttributeMapping(ownerClass, attribute);
        return mapping != null && mapping.isAggregateMapping();
    }

    public boolean isSimpleStateAttribute(Object ownerClass, String attribute) {
        DatabaseMapping mapping = this.resolveAttributeMapping(ownerClass, attribute);
        return mapping != null && mapping.isDirectToFieldMapping();
    }

    public boolean isRelationship(Object ownerClass, String attribute) {
        DatabaseMapping mapping = this.resolveAttributeMapping(ownerClass, attribute);
        return mapping != null && (mapping.isObjectReferenceMapping() || mapping.isOneToManyMapping() || mapping.isManyToManyMapping());
    }

    public boolean isSingleValuedRelationship(Object ownerClass, String attribute) {
        DatabaseMapping mapping = this.resolveAttributeMapping(ownerClass, attribute);
        return mapping != null && mapping.isObjectReferenceMapping();
    }

    public boolean isCollectionValuedRelationship(Object ownerClass, String attribute) {
        DatabaseMapping mapping = this.resolveAttributeMapping(ownerClass, attribute);
        return mapping != null && (mapping.isOneToManyMapping() || mapping.isManyToManyMapping());
    }

    private ClassDescriptor getDescriptor(Object type) {
        return type instanceof Class ? this.session.getDescriptor((Class)type) : null;
    }

    private DatabaseMapping resolveAttributeMapping(Object ownerClass, String attr) {
        ClassDescriptor desc = this.getDescriptor(ownerClass);
        return desc == null ? null : desc.getMappingForAttributeName(attr);
    }

    private Object getType(DatabaseMapping mapping) {
        ClassDescriptor descriptor;
        if (mapping == null) {
            return null;
        }
        Class type = null;
        type = mapping.isForeignReferenceMapping() ? ((descriptor = mapping.getReferenceDescriptor()) == null ? null : descriptor.getJavaClass()) : (mapping.isAggregateMapping() ? ((AggregateMapping)mapping).getReferenceClass() : mapping.getAttributeClassification());
        return type;
    }
}

