/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.descriptors;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.internal.descriptors.ObjectBuilder;
import oracle.toplink.essentials.internal.descriptors.OptimisticLockingPolicy;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.queryframework.FetchGroup;
import oracle.toplink.essentials.queryframework.FetchGroupTracker;
import oracle.toplink.essentials.queryframework.ObjectLevelReadQuery;

public class FetchGroupManager {
    private Map fetchGroups = null;
    private FetchGroup defaultFetchGroup;
    private ClassDescriptor descriptor;

    public void addFetchGroup(FetchGroup group) {
        this.getFetchGroups().put(group.getName(), group);
    }

    public Map getFetchGroups() {
        if (this.fetchGroups == null) {
            this.fetchGroups = new HashMap(2);
        }
        return this.fetchGroups;
    }

    public FetchGroup getDefaultFetchGroup() {
        return this.defaultFetchGroup;
    }

    public FetchGroup getFetchGroup(String groupName) {
        return (FetchGroup)this.getFetchGroups().get(groupName);
    }

    public void setDefaultFetchGroup(FetchGroup newDefaultFetchGroup) {
        this.defaultFetchGroup = newDefaultFetchGroup;
    }

    public boolean isPartialObject(Object domainObject) {
        if (domainObject != null) {
            FetchGroup fetchGroupInCache = ((FetchGroupTracker)domainObject).getFetchGroup();
            return fetchGroupInCache != null;
        }
        return false;
    }

    public boolean isObjectValidForFetchGroup(Object object, FetchGroup fetchGroup) {
        FetchGroup groupInObject = ((FetchGroupTracker)object).getFetchGroup();
        return groupInObject == null || groupInObject.isSupersetOf(fetchGroup);
    }

    public boolean shouldWriteInto(Object cachedObject, Object clone) {
        if (this.isPartialObject(clone)) {
            FetchGroup fetchGroupInSrc = ((FetchGroupTracker)cachedObject).getFetchGroup();
            FetchGroup fetchGroupInTarg = ((FetchGroupTracker)clone).getFetchGroup();
            return fetchGroupInTarg != null && !fetchGroupInTarg.isSupersetOf(fetchGroupInSrc) || ((FetchGroupTracker)cachedObject).shouldRefreshFetchGroup();
        }
        return false;
    }

    public void writePartialIntoClones(Object partialObject, Object workingClone, UnitOfWorkImpl uow) {
        FetchGroup fetchGroupInClone = ((FetchGroupTracker)workingClone).getFetchGroup();
        FetchGroup fetchGroupInObject = ((FetchGroupTracker)partialObject).getFetchGroup();
        Object backupClone = uow.getBackupClone(workingClone);
        if (((FetchGroupTracker)partialObject).shouldRefreshFetchGroup()) {
            this.refreshFetchGroupIntoClones(partialObject, workingClone, backupClone, fetchGroupInObject, fetchGroupInClone, uow);
        } else {
            this.revertDataIntoUnfetchedAttributesOfClones(partialObject, workingClone, backupClone, fetchGroupInObject, fetchGroupInClone, uow);
        }
        fetchGroupInObject = this.unionFetchGroups(fetchGroupInObject, fetchGroupInClone);
        this.setObjectFetchGroup(workingClone, fetchGroupInObject);
        this.setObjectFetchGroup(backupClone, fetchGroupInObject);
    }

    private void refreshFetchGroupIntoClones(Object cachedObject, Object workingClone, Object backupClone, FetchGroup fetchGroupInObject, FetchGroup fetchGroupInClone, UnitOfWorkImpl uow) {
        Vector<DatabaseMapping> mappings = this.descriptor.getMappings();
        boolean isObjectPartial = fetchGroupInObject != null;
        Set fetchedAttributes = isObjectPartial ? fetchGroupInObject.getAttributes() : null;
        for (int index = 0; index < mappings.size(); ++index) {
            DatabaseMapping mapping = mappings.get(index);
            if (isObjectPartial && (fetchedAttributes == null || !fetchedAttributes.contains(mapping.getAttributeName()))) continue;
            mapping.buildClone(cachedObject, workingClone, uow, null);
            mapping.buildClone(workingClone, backupClone, uow, null);
        }
    }

    private void revertDataIntoUnfetchedAttributesOfClones(Object cachedObject, Object workingClone, Object backupClone, FetchGroup fetchGroupInObject, FetchGroup fetchGroupInClone, UnitOfWorkImpl uow) {
        if (this.isObjectValidForFetchGroup(workingClone, fetchGroupInObject)) {
            return;
        }
        Vector<DatabaseMapping> mappings = this.descriptor.getMappings();
        Set fetchedAttributesClone = fetchGroupInClone.getAttributes();
        for (int index = 0; index < mappings.size(); ++index) {
            DatabaseMapping mapping = mappings.get(index);
            if (!this.isAttributeFetched(cachedObject, mapping.getAttributeName()) || fetchedAttributesClone.contains(mapping.getAttributeName())) continue;
            mapping.buildClone(cachedObject, workingClone, uow, null);
            mapping.buildClone(workingClone, backupClone, uow, null);
        }
    }

    public void copyFetchGroupInto(Object source, Object target) {
        if (this.isPartialObject(source)) {
            ((FetchGroupTracker)target).setFetchGroup(((FetchGroupTracker)source).getFetchGroup());
        }
    }

    public void unionFetchGroupIntoObject(Object source, FetchGroup newFetchGroup) {
        FetchGroupTracker tracker = (FetchGroupTracker)source;
        tracker.setFetchGroup(this.unionFetchGroups(tracker.getFetchGroup(), newFetchGroup));
    }

    public FetchGroup unionFetchGroups(FetchGroup first, FetchGroup second) {
        if (first == null || second == null) {
            return null;
        }
        if (first.isSupersetOf(second)) {
            return first;
        }
        if (second.isSupersetOf(first)) {
            return second;
        }
        StringBuffer unionGroupName = new StringBuffer(first.getName());
        unionGroupName.append("_");
        unionGroupName.append(second.getName());
        FetchGroup unionFetchGroup = new FetchGroup(unionGroupName.toString());
        unionFetchGroup.addAttributes(first.getAttributes());
        unionFetchGroup.addAttributes(second.getAttributes());
        return unionFetchGroup;
    }

    public void reset(Object source) {
        ((FetchGroupTracker)source).resetFetchGroup();
    }

    public void setObjectFetchGroup(Object source, FetchGroup fetchGroup) {
        if (this.descriptor.getFetchGroupManager() != null) {
            ((FetchGroupTracker)source).setFetchGroup(fetchGroup);
        }
    }

    public void setRefreshOnFetchGroupToObject(Object source, boolean shouldRefreshOnFetchgroup) {
        ((FetchGroupTracker)source).setShouldRefreshFetchGroup(shouldRefreshOnFetchgroup);
    }

    public boolean isAttributeFetched(Object object, String attributeName) {
        FetchGroup fetchgroup = ((FetchGroupTracker)object).getFetchGroup();
        return fetchgroup == null || fetchgroup.getAttributes().contains(attributeName);
    }

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public ClassDescriptor getClassDescriptor() {
        return this.getDescriptor();
    }

    public void setDescriptor(ClassDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public void prepareQueryWithFetchGroup(ObjectLevelReadQuery query) {
        query.initializeFetchGroup();
        if (query.getFetchGroup() == null || query.getFetchGroup().hasFetchGroupAttributeExpressions()) {
            return;
        }
        if (query.isReportQuery()) {
            throw QueryException.fetchGroupNotSupportOnReportQuery();
        }
        if (query.hasPartialAttributeExpressions()) {
            throw QueryException.fetchGroupNotSupportOnPartialAttributeReading();
        }
        Set attributes = query.getFetchGroup().getAttributes();
        ObjectBuilder builder = query.getDescriptor().getObjectBuilder();
        for (DatabaseMapping pkMapping : builder.getPrimaryKeyMappings()) {
            DatabaseField pkField = pkMapping.getField();
            attributes.add(pkMapping.getAttributeName());
        }
        OptimisticLockingPolicy lockingPolicy = this.getDescriptor().getOptimisticLockingPolicy();
        if (query.shouldMaintainCache() && lockingPolicy != null) {
            lockingPolicy.prepareFetchGroupForReadQuery(query.getFetchGroup(), query);
        }
        for (String attrName : attributes) {
            DatabaseMapping mapping = builder.getMappingForAttributeName(attrName);
            if (mapping == null) {
                throw QueryException.fetchGroupAttributeNotMapped(attrName);
            }
            if (mapping.isCollectionMapping()) {
                query.getFetchGroup().addFetchGroupAttribute(query.getExpressionBuilder().anyOf(attrName));
                continue;
            }
            query.getFetchGroup().addFetchGroupAttribute(query.getExpressionBuilder().get(attrName));
        }
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }
}

