/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.databaseaccess;

import java.io.Serializable;
import oracle.toplink.essentials.internal.helper.Helper;

public class FieldTypeDefinition
implements Serializable {
    protected String name;
    protected int defaultSize = 10;
    protected int defaultSubSize;
    protected boolean isSizeAllowed = true;
    protected boolean isSizeRequired = false;
    protected int maxPrecision = 10;
    protected int minScale = 0;
    protected int maxScale = 0;
    protected boolean shouldAllowNull = true;

    public FieldTypeDefinition() {
    }

    public FieldTypeDefinition(String databaseTypeName) {
        this();
        this.name = databaseTypeName;
    }

    public FieldTypeDefinition(String databaseTypeName, int defaultSize) {
        this();
        this.name = databaseTypeName;
        this.defaultSize = defaultSize;
        this.isSizeRequired = true;
        this.setMaxPrecision(defaultSize);
    }

    public FieldTypeDefinition(String databaseTypeName, int defaultSize, int defaultSubSize) {
        this();
        this.name = databaseTypeName;
        this.defaultSize = defaultSize;
        this.defaultSubSize = defaultSubSize;
        this.isSizeRequired = true;
        this.setMaxPrecision(defaultSize);
        this.setMaxScale(defaultSubSize);
    }

    public FieldTypeDefinition(String databaseTypeName, boolean allowsSize) {
        this();
        this.name = databaseTypeName;
        this.isSizeAllowed = allowsSize;
    }

    public FieldTypeDefinition(String databaseTypeName, boolean allowsSize, boolean allowsNull) {
        this(databaseTypeName, allowsSize);
        this.shouldAllowNull = allowsNull;
    }

    public int getDefaultSize() {
        return this.defaultSize;
    }

    public int getDefaultSubSize() {
        return this.defaultSubSize;
    }

    public int getMaxPrecision() {
        return this.maxPrecision;
    }

    public int getMaxScale() {
        return this.maxScale;
    }

    public int getMinScale() {
        return this.minScale;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSizeAllowed() {
        return this.isSizeAllowed;
    }

    public boolean isSizeRequired() {
        return this.isSizeRequired;
    }

    public boolean shouldAllowNull() {
        return this.shouldAllowNull;
    }

    public void setDefaultSize(int defaultSize) {
        this.defaultSize = defaultSize;
    }

    public void setDefaultSubSize(int defaultSubSize) {
        this.defaultSubSize = defaultSubSize;
    }

    public void setIsSizeAllowed(boolean aBoolean) {
        this.isSizeAllowed = aBoolean;
    }

    public void setIsSizeRequired(boolean aBoolean) {
        this.isSizeRequired = aBoolean;
    }

    public void setShouldAllowNull(boolean allowsNull) {
        this.shouldAllowNull = allowsNull;
    }

    public FieldTypeDefinition setLimits(int maxPrecision, int minScale, int maxScale) {
        this.setMaxPrecision(maxPrecision);
        this.setMinScale(minScale);
        this.setMaxScale(maxScale);
        return this;
    }

    public void setMaxPrecision(int maximum) {
        this.maxPrecision = maximum;
    }

    public void setMaxScale(int maximum) {
        this.maxScale = maximum;
    }

    public void setMinScale(int minimum) {
        this.minScale = minimum;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSizeDisallowed() {
        this.setIsSizeAllowed(false);
    }

    public void setSizeOptional() {
        this.setIsSizeRequired(false);
        this.setIsSizeAllowed(true);
    }

    public void setSizeRequired() {
        this.setIsSizeRequired(true);
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "(" + this.getName() + ")";
    }
}

