/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2007, Oracle. All rights reserved.  
package oracle.toplink.essentials.queryframework;

import oracle.toplink.essentials.exceptions.*;

/**
 * <p><b>Purpose</b>:
 * Used for inserting new objects into the database.
 *
 * <p><b>Description</b>:
 * This class does not have much behavior.
 * It inherits most of it's behavior from WriteObjectQuery
 *
 * @author Yvon Lavoie
 * @since TOPLink/Java 1.0
 */
public class InsertObjectQuery extends WriteObjectQuery {

    /**
     * PUBLIC:
     * Default constructor.
     */
    public InsertObjectQuery() {
        super();
    }

    /**
     * PUBLIC:
     * Create an insert query with the object being inserted.
     */
    public InsertObjectQuery(Object objectToInsert) {
        this();
        setObject(objectToInsert);
    }

    /**
     * PUBLIC:
     * Create an insert query with the custom call.
     */
    public InsertObjectQuery(Call call) {
        this();
        setCall(call);
    }

    /**
     * INTERNAL:
     * Perform an insert.
     */
    public void executeCommit() throws DatabaseException {
        // object will only be null if the transaction is being commited directly from a changeset
        if (getObject() != null) {
            // if the object is not null then it is more effecient to build the row from the
            // object then the changeSet.
            getQueryMechanism().insertObjectForWrite();
        } else {
            // has a changeSet so we must use it in the case that there is no object
            getQueryMechanism().insertObjectForWriteWithChangeSet();
        }
    }

    /**
     * INTERNAL:
     * Prepare the receiver for execution in a session.
     */
    protected void prepare() {
        super.prepare();

        getQueryMechanism().prepareInsertObject();
    }

    /**
     * PUBLIC:
     * Return if this is an insert object query.
     */
    public boolean isInsertObjectQuery() {
        return true;
    }
}
