/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 2005, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.weaving;

// J2SE imports

// ASM imports
import oracle.toplink.libraries.asm.Type;

import oracle.toplink.essentials.internal.descriptors.InstanceVariableAttributeAccessor;

import oracle.toplink.essentials.mappings.OneToOneMapping;

/**
 * INTERNAL:
 * Internal helper class that holds details of a persistent attribute.
 * Used by {@link ClassDetails}
 * 
 */

public class AttributeDetails {
	
	// the name of this attribute (obviously!)
    protected String attributeName;

	protected String referenceClass;

	protected boolean weaveValueHolders = false;
    
    protected OneToOneMapping mapping = null;
    
    protected String getterMethodName = null;
    protected String setterMethodName = null;
    
	// is this attribute mapped using a CollectionMapping?
	protected boolean collectionMapping = false;
    
    protected boolean isMappedWithAttributeAccess = false;
    
    protected boolean attributeOnSuperClass = false;

	public AttributeDetails(String attributeName) {
	    this.attributeName = attributeName;
	}

	public String getAttributeName() {
	    return this.attributeName;
	}
    
    public OneToOneMapping getMapping(){
        return mapping;
    }

    public String getGetterMethodName(){
        return getterMethodName;
    }
    
    public String getSetterMethodName(){
        return setterMethodName;
    }

	public String getReferenceClass() {
		return referenceClass;
	}

    public void setAttributeOnSuperClass(boolean onSuperClass){
        attributeOnSuperClass = onSuperClass;
    }

    public boolean isAttributeOnSuperClass(){
        return attributeOnSuperClass;
    }

	public boolean weaveValueHolders() {
		return weaveValueHolders;
	}
	public void weaveVH(boolean weaveValueHolders, OneToOneMapping mapping) {
		this.weaveValueHolders = weaveValueHolders;
        this.mapping = mapping;
        this.getterMethodName = mapping.getGetMethodName();
        this.setterMethodName = mapping.getSetMethodName();
	}

	public boolean isCollectionMapping() {
		return collectionMapping;
	}
	public void setCollectionMapping(boolean collectionMapping) {
		this.collectionMapping = collectionMapping;
	}
    
    public void setIsMappedWithAttributeAccess(boolean isMappedWithAttributeAccess){
        this.isMappedWithAttributeAccess = isMappedWithAttributeAccess;
    }
    
    public boolean isMappedWithAttributeAccess(){
        return isMappedWithAttributeAccess;
    }
	
	public String toString() {
		StringBuffer sb = new StringBuffer(attributeName);
		if (referenceClass != null) {
			sb.append("[");
			sb.append(referenceClass);
			sb.append("]");
		}
		sb.append(" weaveVH: ");
		if (weaveValueHolders()) {
			sb.append("true");
		}
		else {
			sb.append("false");
		}
		sb.append(" CM: ");
		if (isCollectionMapping()) {
			sb.append("true");
		}
		else {
			sb.append("false");
		}
		return sb.toString();
	}

}
