/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2007, Oracle. All rights reserved.  
/* Copyright (c) 2005, 2006, Oracle. All rights reserved.  */

/*
   DESCRIPTION
    Created to remove EJBQLCall's Antlr.jar compile dependency.  

   MODIFIED    (MM/DD/YY)
    gyorke      03/10/06 - 
    pkrogh      10/07/05 - 
    pkrogh      09/29/05 - 
    tware       09/22/05 - 
    gyorke      08/09/05 - gyorke_10-essentials-directory-creation_050808
    dmahar      08/05/05 - 
    cdelahun    04/29/05 - cdelahun_10_main_4324564_050429
    cdelahun    04/29/05 - Creation
 */

package oracle.toplink.essentials.internal.parsing.ejbql;

import oracle.toplink.essentials.internal.parsing.EJBQLParseTree;
import oracle.toplink.essentials.queryframework.ObjectLevelReadQuery;
import oracle.toplink.essentials.internal.sessions.AbstractSession;

public class EJBQLParserFactory
{
  public EJBQLParserFactory(){}
  
  public EJBQLParser buildParserFor(String ejbqlString){
    return EJBQLParser.buildParserFor(ejbqlString);
  }
  public EJBQLParser parseEJBQLString(String ejbqlString){
    EJBQLParser parser = buildParserFor(ejbqlString);
    parser.parse();
    return parser;
  }

  /**
   * Populate the query using the information retrieved from parsing the EJBQL.
   */
  public void populateQuery(String ejbqlString, ObjectLevelReadQuery theQuery, AbstractSession session){
    EJBQLParser parser = parseEJBQLString(ejbqlString);
    EJBQLParseTree parseTree = parser.getParseTree();
    parseTree.populateQuery(theQuery, session);
  }
  
}
