/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2007, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.expressions;

import java.util.*;
import oracle.toplink.essentials.querykeys.*;
import oracle.toplink.essentials.expressions.*;
import oracle.toplink.essentials.descriptors.ClassDescriptor;

/**
 * This class represents a "query key" that isn't really there
 * in the descriptors. For example, I could use this to create
 * an 'employee' query key from an 'address' node even if addresses
 * don't know their employee. It's called manual, because I will
 * have to provide the relevant join criteria myself (normally based
 * on a reverse relationship. Motivated by batch reading.
 */
public class ManualQueryKeyExpression extends QueryKeyExpression {
    public ManualQueryKeyExpression() {
        super();
    }

    public ManualQueryKeyExpression(String impliedRelationshipName, Expression base) {
        super(impliedRelationshipName, base);
    }

    public ManualQueryKeyExpression(String impliedRelationshipName, Expression base, ClassDescriptor descriptor) {
        super(impliedRelationshipName, base);
        this.descriptor = descriptor;
    }

    /**
     * INTERNAL:
     * Used for debug printing.
     */
    public String descriptionOfNodeType() {
        return "Manual Query Key";
    }

    /**
     * INTERNAL:
     * If we ever get in the circumstance of a manual query key
     * to an aggregate, then we can assume that the owner of that
     * aggregate isn't participating (and even if it is, we can't
     * know which node it is, so *DO* use the aggregate's parents tables
     */
    public Vector getOwnedTables() {
        if (getDescriptor() == null) {
            return null;
        } else {
            return getDescriptor().getTables();
        }
    }

    public QueryKey getQueryKeyOrNull() {
        return null;
    }

    /**
     * INTERNAL:
     * We can never be an attribute, we're always a join
     */
    public boolean isAttribute() {
        return false;
    }

    public Expression mappingCriteria() {
        return null;
    }

    /**
     * INTERNAL:
     * This expression is built on a different base than the one we want. Rebuild it and
     * return the root of the new tree
     */
    public Expression rebuildOn(Expression newBase) {
        ObjectExpression newLocalBase = (ObjectExpression)getBaseExpression().rebuildOn(newBase);
        return newLocalBase.getManualQueryKey(getName(), getDescriptor());
    }

    /**
     * INTERNAL:
     * Rebuild myself against the base, with the values of parameters supplied by the context
     * expression. This is used for transforming a standalone expression (e.g. the join criteria of a mapping)
     * into part of some larger expression. You normally would not call this directly, instead calling twist
     * See the comment there for more details"
     */
    public Expression twistedForBaseAndContext(Expression newBase, Expression context) {
        ObjectExpression twistedBase = (ObjectExpression)getBaseExpression().twistedForBaseAndContext(newBase, context);
        return twistedBase.getManualQueryKey(getName(), getDescriptor());

    }

    /**
     * Do any required validation for this node. Throw an exception if it's incorrect.
     */
    public void validateNode() {
        // Override super.validateNode() because those criteria don't apply to us
    }
}
