/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2007, Oracle. All rights reserved.  
package oracle.toplink.essentials.exceptions.i18n;

import java.util.ListResourceBundle;

/**
 * INTERNAL:
 */
public class XMLPlatformExceptionResource extends ListResourceBundle {
    static final Object[][] contents = {
                                           { "27001", "The XML Platform class was not found: {0}" },
                                           { "27002", "The XML Platform could not be instantiated: {0}" },
                                           { "27003", "A new XML document could not be created." },
                                           { "27004", "The XPath was invalid." },
                                           { "27005", "An error occurred while validating the document." },
                                           { "27006", "Could not resolve XML Schema:  {0}" },
                                           { "27101", "An error occurred while parsing the document." },
                                           { "27102", "File not found: [{0}]" },
                                           { "27103", "** Parsing error, line [{0}], uri [{1}] [{2}]" },
                                           { "27201", "An error occurred while transforming the document." },
                                           { "27202", "Unknown type encountered: {0}" },
    };

    /**
     * Return the lookup table.
     */
    protected Object[][] getContents() {
        return contents;
    }
}
