/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2007, Oracle. All rights reserved.  
package oracle.toplink.essentials.ejb.cmp3;

import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import javax.persistence.Persistence;
import javax.persistence.spi.PersistenceUnitInfo;

import oracle.toplink.essentials.ejb.cmp3.persistence.PersistenceUnitProcessor;
import oracle.toplink.essentials.ejb.cmp3.persistence.SEPersistenceUnitInfo;
import oracle.toplink.essentials.ejb.cmp3.persistence.Archive;
import oracle.toplink.essentials.internal.ejb.cmp3.EntityManagerSetupImpl;

/**
 *  Utility used to statically weave entities for use in TopLink EJB 3.0
 *  
 *  The main method of this class should be invoked with the -javaagent tag to initiate weaving.
 *  
 *  The following system arguments should be provided:
 *  -javaagent:<toplink_agent_jar_location>
 *  -Dtoplink.weaving.output.path=<location_to_put_weaved_classes>
 *  -Dtoplink.validation-only=true
 *  -Dtoplink.weaving.overwrite.existing=true if you wish the output of static weaving to overwrite existing classes 
 *  
 *  Weaving will occur for all persistence units found on the classpath.
 */
public class StaticWeaver {


    /**
     *  This method will search for all of the persistence archives on the classpath and weave
     *  all the classes associated with those persistence units.
     */
    public static void main(String[] args) {
        Set<Archive> pars = PersistenceUnitProcessor.findPersistenceArchives();
        Iterator<Archive> parIterator = pars.iterator();
        while (parIterator.hasNext()){
            List<SEPersistenceUnitInfo> puInfoList = PersistenceUnitProcessor.getPersistenceUnits(parIterator.next(), Thread.currentThread().getContextClassLoader());
            Iterator<SEPersistenceUnitInfo> puInfoListIterator = puInfoList.iterator();
            while (puInfoListIterator.hasNext()){
                Persistence.createEntityManagerFactory(puInfoListIterator.next().getPersistenceUnitName());
            }
        }
    }

}
