/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.xml.deser;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.core.util.JsonParserDelegate;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.PropertyName;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.cfg.MapperConfig;
import tools.jackson.databind.deser.SettableBeanProperty;
import tools.jackson.databind.deser.bean.BeanDeserializerBase;
import tools.jackson.databind.deser.std.DelegatingDeserializer;
import tools.jackson.databind.jsontype.TypeDeserializer;
import tools.jackson.dataformat.xml.deser.ElementWrappable;
import tools.jackson.dataformat.xml.util.TypeUtil;

public class WrapperHandlingDeserializer
extends DelegatingDeserializer {
    protected final Set<String> _namesToWrap;
    protected final JavaType _type;
    protected final boolean _caseInsensitive;

    public WrapperHandlingDeserializer(BeanDeserializerBase delegate) {
        this(delegate, null);
    }

    public WrapperHandlingDeserializer(BeanDeserializerBase delegate, Set<String> namesToWrap) {
        super((ValueDeserializer)delegate);
        this._namesToWrap = namesToWrap;
        this._type = delegate.getValueType();
        this._caseInsensitive = delegate.isCaseInsensitive();
    }

    protected ValueDeserializer<?> newDelegatingInstance(ValueDeserializer<?> newDelegatee0) {
        throw new IllegalStateException("Internal error: should never get called");
    }

    public ValueDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
        JavaType vt = this._type;
        if (vt == null) {
            vt = ctxt.constructType(this._delegatee.handledType());
        }
        ValueDeserializer del = ctxt.handleSecondaryContextualization(this._delegatee, property, vt);
        BeanDeserializerBase newDelegatee = this._verifyDeserType(del);
        Iterator it = newDelegatee.properties();
        HashSet<String> unwrappedNames = null;
        while (it.hasNext()) {
            PropertyName wrapperName;
            SettableBeanProperty prop = (SettableBeanProperty)it.next();
            JavaType type = prop.getType();
            if (!TypeUtil.isIndexedType(type) || (wrapperName = prop.getWrapperName()) != null && wrapperName != PropertyName.NO_NAME) continue;
            if (unwrappedNames == null) {
                unwrappedNames = new HashSet<String>();
            }
            unwrappedNames.add(prop.getName());
            for (PropertyName alias : prop.findAliases((MapperConfig)ctxt.getConfig())) {
                unwrappedNames.add(alias.getSimpleName());
            }
        }
        if (unwrappedNames == null) {
            return newDelegatee;
        }
        return new WrapperHandlingDeserializer(newDelegatee, unwrappedNames);
    }

    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        this._configureParser(p);
        return this._delegatee.deserialize(p, ctxt);
    }

    public Object deserialize(JsonParser p, DeserializationContext ctxt, Object intoValue) throws JacksonException {
        this._configureParser(p);
        return this._delegatee.deserialize(p, ctxt, intoValue);
    }

    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws JacksonException {
        this._configureParser(p);
        return this._delegatee.deserializeWithType(p, ctxt, typeDeserializer);
    }

    protected final void _configureParser(JsonParser p) throws JacksonException {
        JsonToken t;
        while (p instanceof JsonParserDelegate) {
            p = ((JsonParserDelegate)p).delegate();
        }
        if (p instanceof ElementWrappable && this._namesToWrap != null && ((t = p.currentToken()) == JsonToken.START_OBJECT || t == JsonToken.START_ARRAY || t == JsonToken.PROPERTY_NAME)) {
            ((ElementWrappable)p).addVirtualWrapping(this._namesToWrap, this._caseInsensitive);
        }
    }

    protected BeanDeserializerBase _verifyDeserType(ValueDeserializer<?> deser) {
        if (!(deser instanceof BeanDeserializerBase)) {
            throw new IllegalArgumentException("Can not change delegate to be of type " + deser.getClass().getName());
        }
        return (BeanDeserializerBase)deser;
    }
}

