/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.xml;

import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import tools.jackson.core.ErrorReportConfiguration;
import tools.jackson.core.StreamReadConstraints;
import tools.jackson.core.StreamWriteConstraints;
import tools.jackson.core.base.DecorableTSFactory;
import tools.jackson.dataformat.xml.XmlFactory;
import tools.jackson.dataformat.xml.XmlNameProcessor;
import tools.jackson.dataformat.xml.XmlNameProcessors;
import tools.jackson.dataformat.xml.XmlReadFeature;
import tools.jackson.dataformat.xml.XmlWriteFeature;

public class XmlFactoryBuilder
extends DecorableTSFactory.DecorableTSFBuilder<XmlFactory, XmlFactoryBuilder> {
    protected int _formatParserFeatures;
    protected int _formatGeneratorFeatures;
    protected XMLInputFactory _xmlInputFactory;
    protected XMLOutputFactory _xmlOutputFactory;
    protected String _nameForTextElement;
    protected ClassLoader _classLoaderForStax;
    protected XmlNameProcessor _nameProcessor;

    protected XmlFactoryBuilder() {
        super(StreamReadConstraints.defaults(), StreamWriteConstraints.defaults(), ErrorReportConfiguration.defaults(), XmlFactory.DEFAULT_XML_READ_FEATURE_FLAGS, XmlFactory.DEFAULT_XML_WRITE_FEATURE_FLAGS);
        this._classLoaderForStax = null;
        this._nameProcessor = XmlNameProcessors.newPassthroughProcessor();
        this._nameForTextElement = "";
    }

    public XmlFactoryBuilder(XmlFactory base) {
        super((DecorableTSFactory)base);
        this._xmlInputFactory = base._xmlInputFactory;
        this._xmlOutputFactory = base._xmlOutputFactory;
        this._nameForTextElement = base._cfgNameForTextElement;
        this._nameProcessor = base._nameProcessor;
        this._classLoaderForStax = null;
    }

    public String nameForTextElement() {
        return this._nameForTextElement;
    }

    public XMLInputFactory xmlInputFactory() {
        if (this._xmlInputFactory == null) {
            return XmlFactoryBuilder.defaultXmlInputFactory(this._classLoaderForStax);
        }
        return this._xmlInputFactory;
    }

    protected XMLInputFactory defaultXmlInputFactory() {
        return XmlFactoryBuilder.defaultXmlInputFactory(this.staxClassLoader());
    }

    protected static XMLInputFactory defaultXmlInputFactory(ClassLoader cl) {
        XMLInputFactory xmlIn;
        try {
            xmlIn = XMLInputFactory.newFactory(XMLInputFactory.class.getName(), cl);
        }
        catch (NoSuchMethodError | FactoryConfigurationError e) {
            xmlIn = XMLInputFactory.newFactory();
        }
        xmlIn.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        xmlIn.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        return xmlIn;
    }

    public XMLOutputFactory xmlOutputFactory() {
        if (this._xmlOutputFactory == null) {
            return XmlFactoryBuilder.defaultXmlOutputFactory(this._classLoaderForStax);
        }
        return this._xmlOutputFactory;
    }

    protected XMLOutputFactory defaultXmlOutputFactory() {
        return XmlFactoryBuilder.defaultXmlOutputFactory(this.staxClassLoader());
    }

    protected static XMLOutputFactory defaultXmlOutputFactory(ClassLoader cl) {
        XMLOutputFactory xmlOut;
        try {
            xmlOut = XMLOutputFactory.newFactory(XMLOutputFactory.class.getName(), cl);
        }
        catch (NoSuchMethodError | FactoryConfigurationError e) {
            xmlOut = XMLOutputFactory.newFactory();
        }
        xmlOut.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
        return xmlOut;
    }

    protected ClassLoader staxClassLoader() {
        return this._classLoaderForStax == null ? ((Object)((Object)this)).getClass().getClassLoader() : this._classLoaderForStax;
    }

    public XmlNameProcessor xmlNameProcessor() {
        return this._nameProcessor;
    }

    public XmlFactoryBuilder enable(XmlReadFeature f) {
        this._formatParserFeatures |= f.getMask();
        return (XmlFactoryBuilder)this._this();
    }

    public XmlFactoryBuilder enable(XmlReadFeature first, XmlReadFeature ... other) {
        this._formatParserFeatures |= first.getMask();
        for (XmlReadFeature f : other) {
            this._formatParserFeatures |= f.getMask();
        }
        return (XmlFactoryBuilder)this._this();
    }

    public XmlFactoryBuilder disable(XmlReadFeature f) {
        this._formatParserFeatures &= ~f.getMask();
        return (XmlFactoryBuilder)this._this();
    }

    public XmlFactoryBuilder disable(XmlReadFeature first, XmlReadFeature ... other) {
        this._formatParserFeatures &= ~first.getMask();
        for (XmlReadFeature f : other) {
            this._formatParserFeatures &= ~f.getMask();
        }
        return (XmlFactoryBuilder)this._this();
    }

    public XmlFactoryBuilder configure(XmlReadFeature f, boolean state) {
        return state ? this.enable(f) : this.disable(f);
    }

    public XmlFactoryBuilder enable(XmlWriteFeature f) {
        this._formatGeneratorFeatures |= f.getMask();
        return (XmlFactoryBuilder)this._this();
    }

    public XmlFactoryBuilder enable(XmlWriteFeature first, XmlWriteFeature ... other) {
        this._formatGeneratorFeatures |= first.getMask();
        for (XmlWriteFeature f : other) {
            this._formatGeneratorFeatures |= f.getMask();
        }
        return (XmlFactoryBuilder)this._this();
    }

    public XmlFactoryBuilder disable(XmlWriteFeature f) {
        this._formatGeneratorFeatures &= ~f.getMask();
        return (XmlFactoryBuilder)this._this();
    }

    public XmlFactoryBuilder disable(XmlWriteFeature first, XmlWriteFeature ... other) {
        this._formatGeneratorFeatures &= ~first.getMask();
        for (XmlWriteFeature f : other) {
            this._formatGeneratorFeatures &= ~f.getMask();
        }
        return (XmlFactoryBuilder)this._this();
    }

    public XmlFactoryBuilder configure(XmlWriteFeature f, boolean state) {
        return state ? this.enable(f) : this.disable(f);
    }

    public XmlFactoryBuilder nameForTextElement(String name) {
        this._nameForTextElement = name;
        return (XmlFactoryBuilder)this._this();
    }

    public XmlFactoryBuilder xmlInputFactory(XMLInputFactory xmlIn) {
        this._xmlInputFactory = xmlIn;
        return (XmlFactoryBuilder)this._this();
    }

    public XmlFactoryBuilder xmlOutputFactory(XMLOutputFactory xmlOut) {
        this._xmlOutputFactory = xmlOut;
        return (XmlFactoryBuilder)this._this();
    }

    public XmlFactoryBuilder staxClassLoader(ClassLoader cl) {
        this._classLoaderForStax = cl;
        return (XmlFactoryBuilder)this._this();
    }

    public XmlFactoryBuilder xmlNameProcessor(XmlNameProcessor nameProcessor) {
        this._nameProcessor = nameProcessor;
        return (XmlFactoryBuilder)this._this();
    }

    public XmlFactory build() {
        return new XmlFactory(this);
    }
}

