/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.xml;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.annotation.Annotation;
import tools.jackson.databind.PropertyName;
import tools.jackson.databind.cfg.MapperConfig;
import tools.jackson.databind.introspect.Annotated;
import tools.jackson.databind.introspect.AnnotatedClass;
import tools.jackson.databind.introspect.JacksonAnnotationIntrospector;
import tools.jackson.dataformat.xml.XmlAnnotationIntrospector;
import tools.jackson.dataformat.xml.annotation.JacksonXmlCData;
import tools.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import tools.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import tools.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import tools.jackson.dataformat.xml.annotation.JacksonXmlText;

public class JacksonXmlAnnotationIntrospector
extends JacksonAnnotationIntrospector
implements XmlAnnotationIntrospector {
    private static final long serialVersionUID = 1L;
    private static final Class<? extends Annotation>[] ANNOTATIONS_TO_INFER_XML_PROP = new Class[]{JacksonXmlText.class, JacksonXmlElementWrapper.class};
    public static final boolean DEFAULT_USE_WRAPPER = true;
    protected boolean _cfgDefaultUseWrapper;

    public JacksonXmlAnnotationIntrospector() {
        this(true);
    }

    public JacksonXmlAnnotationIntrospector(boolean defaultUseWrapper) {
        this._cfgDefaultUseWrapper = defaultUseWrapper;
    }

    public void setDefaultUseWrapper(boolean b) {
        this._cfgDefaultUseWrapper = b;
    }

    public PropertyName findWrapperName(MapperConfig<?> config, Annotated ann) {
        JacksonXmlElementWrapper w = (JacksonXmlElementWrapper)this._findAnnotation(ann, JacksonXmlElementWrapper.class);
        if (w != null) {
            if (!w.useWrapping()) {
                return PropertyName.NO_NAME;
            }
            String localName = w.localName();
            if (localName == null || localName.length() == 0) {
                return PropertyName.USE_DEFAULT;
            }
            return PropertyName.construct((String)w.localName(), (String)w.namespace());
        }
        if (this._cfgDefaultUseWrapper) {
            return PropertyName.USE_DEFAULT;
        }
        return null;
    }

    public PropertyName findRootName(MapperConfig<?> config, AnnotatedClass ac) {
        JacksonXmlRootElement root = (JacksonXmlRootElement)this._findAnnotation((Annotated)ac, JacksonXmlRootElement.class);
        if (root != null) {
            String local = root.localName();
            String ns = root.namespace();
            if (local.length() == 0 && ns.length() == 0) {
                return PropertyName.USE_DEFAULT;
            }
            return new PropertyName(local, ns);
        }
        return super.findRootName(config, ac);
    }

    public String findNamespace(MapperConfig<?> config, Annotated ann) {
        String ns1 = null;
        JacksonXmlProperty xmlProp = (JacksonXmlProperty)this._findAnnotation(ann, JacksonXmlProperty.class);
        if (xmlProp != null) {
            ns1 = xmlProp.namespace();
        }
        JsonProperty jprop = (JsonProperty)this._findAnnotation(ann, JsonProperty.class);
        String ns2 = null;
        if (jprop != null) {
            ns2 = jprop.namespace();
        }
        if (ns1 == null) {
            return ns2;
        }
        if (ns2 == null) {
            return ns1;
        }
        if (ns1.isEmpty()) {
            return ns2;
        }
        return ns1;
    }

    public Boolean isOutputAsAttribute(MapperConfig<?> config, Annotated ann) {
        JacksonXmlProperty prop = (JacksonXmlProperty)this._findAnnotation(ann, JacksonXmlProperty.class);
        if (prop != null) {
            return prop.isAttribute() ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    public Boolean isOutputAsText(MapperConfig<?> config, Annotated ann) {
        JacksonXmlText prop = (JacksonXmlText)this._findAnnotation(ann, JacksonXmlText.class);
        if (prop != null) {
            return prop.value() ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    public Boolean isOutputAsCData(MapperConfig<?> config, Annotated ann) {
        JacksonXmlCData prop = (JacksonXmlCData)ann.getAnnotation(JacksonXmlCData.class);
        if (prop != null) {
            return prop.value() ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    public PropertyName findNameForSerialization(MapperConfig<?> config, Annotated a) {
        PropertyName pn = PropertyName.merge((PropertyName)this._findXmlName(a), (PropertyName)super.findNameForSerialization(config, a));
        if (pn == null && this._hasOneOf(a, ANNOTATIONS_TO_INFER_XML_PROP)) {
            return PropertyName.USE_DEFAULT;
        }
        return pn;
    }

    public PropertyName findNameForDeserialization(MapperConfig<?> config, Annotated a) {
        PropertyName pn = PropertyName.merge((PropertyName)this._findXmlName(a), (PropertyName)super.findNameForDeserialization(config, a));
        if (pn == null && this._hasOneOf(a, ANNOTATIONS_TO_INFER_XML_PROP)) {
            return PropertyName.USE_DEFAULT;
        }
        return pn;
    }

    protected PropertyName _findXmlName(Annotated a) {
        JacksonXmlProperty pann = (JacksonXmlProperty)this._findAnnotation(a, JacksonXmlProperty.class);
        if (pann != null) {
            return PropertyName.construct((String)pann.localName(), (String)pann.namespace());
        }
        return null;
    }
}

