/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.deser.bean;

import java.util.Map;
import java.util.Set;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.core.sym.PropertyNameMatcher;
import tools.jackson.databind.BeanDescription;
import tools.jackson.databind.DeserializationConfig;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.cfg.CoercionAction;
import tools.jackson.databind.deser.BeanDeserializerBuilder;
import tools.jackson.databind.deser.SettableBeanProperty;
import tools.jackson.databind.deser.bean.BeanAsArrayBuilderDeserializer;
import tools.jackson.databind.deser.bean.BeanDeserializerBase;
import tools.jackson.databind.deser.bean.BeanPropertyMap;
import tools.jackson.databind.deser.bean.PropertyBasedCreator;
import tools.jackson.databind.deser.bean.PropertyValueBuffer;
import tools.jackson.databind.deser.impl.ExternalTypeHandler;
import tools.jackson.databind.deser.impl.ObjectIdReader;
import tools.jackson.databind.deser.impl.UnwrappedPropertyHandler;
import tools.jackson.databind.introspect.AnnotatedMethod;
import tools.jackson.databind.util.ClassUtil;
import tools.jackson.databind.util.IgnorePropertiesUtil;
import tools.jackson.databind.util.NameTransformer;
import tools.jackson.databind.util.TokenBuffer;

public class BuilderBasedDeserializer
extends BeanDeserializerBase {
    protected final AnnotatedMethod _buildMethod;
    protected final JavaType _targetType;
    protected PropertyNameMatcher _propertyNameMatcher;
    protected SettableBeanProperty[] _propertiesByIndex;
    private volatile transient NameTransformer _currentlyTransforming;

    public BuilderBasedDeserializer(BeanDeserializerBuilder builder, BeanDescription.Supplier beanDescRef, JavaType targetType, BeanPropertyMap properties, Map<String, SettableBeanProperty> backRefs, Set<String> ignorableProps, boolean ignoreAllUnknown, boolean hasViews) {
        this(builder, beanDescRef, targetType, properties, backRefs, ignorableProps, ignoreAllUnknown, null, hasViews);
    }

    public BuilderBasedDeserializer(BeanDeserializerBuilder builder, BeanDescription.Supplier beanDescRef, JavaType targetType, BeanPropertyMap properties, Map<String, SettableBeanProperty> backRefs, Set<String> ignorableProps, boolean ignoreAllUnknown, Set<String> includableProps, boolean hasViews) {
        super(builder, beanDescRef, properties, backRefs, ignorableProps, ignoreAllUnknown, includableProps, hasViews);
        this._targetType = targetType;
        this._buildMethod = builder.getBuildMethod();
        if (this._objectIdReader != null) {
            throw new IllegalArgumentException("Cannot use Object Id with Builder-based deserialization (type " + String.valueOf(beanDescRef.getType()) + ")");
        }
    }

    protected BuilderBasedDeserializer(BuilderBasedDeserializer src) {
        this(src, src._ignoreAllUnknown);
    }

    protected BuilderBasedDeserializer(BuilderBasedDeserializer src, boolean ignoreAllUnknown) {
        super((BeanDeserializerBase)src, ignoreAllUnknown);
        this._buildMethod = src._buildMethod;
        this._targetType = src._targetType;
        this._propertyNameMatcher = src._propertyNameMatcher;
        this._propertiesByIndex = src._propertiesByIndex;
    }

    protected BuilderBasedDeserializer(BuilderBasedDeserializer src, UnwrappedPropertyHandler unwrapHandler, PropertyBasedCreator pbCreator, BeanPropertyMap renamedProperties, boolean ignoreAllUnknown) {
        super(src, unwrapHandler, pbCreator, renamedProperties, ignoreAllUnknown);
        this._buildMethod = src._buildMethod;
        this._targetType = src._targetType;
        this._propertyNameMatcher = this._beanProperties.getNameMatcher();
        this._propertiesByIndex = this._beanProperties.getNameMatcherProperties();
    }

    public BuilderBasedDeserializer(BuilderBasedDeserializer src, ObjectIdReader oir) {
        super((BeanDeserializerBase)src, oir);
        this._buildMethod = src._buildMethod;
        this._targetType = src._targetType;
        this._propertyNameMatcher = src._propertyNameMatcher;
        this._propertiesByIndex = src._propertiesByIndex;
    }

    public BuilderBasedDeserializer(BuilderBasedDeserializer src, Set<String> ignorableProps) {
        this(src, ignorableProps, (Set<String>)src._includableProps);
    }

    public BuilderBasedDeserializer(BuilderBasedDeserializer src, Set<String> ignorableProps, Set<String> includableProps) {
        super(src, ignorableProps, includableProps);
        this._buildMethod = src._buildMethod;
        this._targetType = src._targetType;
        this._propertyNameMatcher = src._propertyNameMatcher;
        this._propertiesByIndex = src._propertiesByIndex;
    }

    public BuilderBasedDeserializer(BuilderBasedDeserializer src, BeanPropertyMap props) {
        super((BeanDeserializerBase)src, props);
        this._buildMethod = src._buildMethod;
        this._targetType = src._targetType;
        this._propertyNameMatcher = this._beanProperties.getNameMatcher();
        this._propertiesByIndex = this._beanProperties.getNameMatcherProperties();
    }

    @Override
    protected void initNameMatcher(DeserializationContext ctxt) {
        this._beanProperties.initMatcher(ctxt.tokenStreamFactory());
        this._propertyNameMatcher = this._beanProperties.getNameMatcher();
        this._propertiesByIndex = this._beanProperties.getNameMatcherProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValueDeserializer<Object> unwrappingDeserializer(DeserializationContext ctxt, NameTransformer transformer) {
        if (this._currentlyTransforming == transformer) {
            return this;
        }
        this._currentlyTransforming = transformer;
        try {
            PropertyBasedCreator pbCreator;
            UnwrappedPropertyHandler uwHandler = this._unwrappedPropertyHandler;
            if (uwHandler != null) {
                uwHandler = uwHandler.renameAll(ctxt, transformer);
            }
            if ((pbCreator = this._propertyBasedCreator) != null) {
                pbCreator = pbCreator.renameAll(ctxt, transformer);
            }
            BeanPropertyMap props = this._beanProperties.renameAll(ctxt, transformer);
            BuilderBasedDeserializer builderBasedDeserializer = new BuilderBasedDeserializer(this, uwHandler, pbCreator, props, true);
            return builderBasedDeserializer;
        }
        finally {
            this._currentlyTransforming = null;
        }
    }

    @Override
    public BeanDeserializerBase withObjectIdReader(ObjectIdReader oir) {
        return new BuilderBasedDeserializer(this, oir);
    }

    @Override
    public BeanDeserializerBase withByNameInclusion(Set<String> ignorableProps, Set<String> includableProps) {
        return new BuilderBasedDeserializer(this, ignorableProps, includableProps);
    }

    @Override
    public BeanDeserializerBase withIgnoreAllUnknown(boolean ignoreUnknown) {
        return new BuilderBasedDeserializer(this, ignoreUnknown);
    }

    @Override
    public BeanDeserializerBase withBeanProperties(BeanPropertyMap props) {
        return new BuilderBasedDeserializer(this, props);
    }

    @Override
    protected BeanDeserializerBase asArrayDeserializer() {
        return new BeanAsArrayBuilderDeserializer(this, this._targetType, this._beanProperties.getPrimaryProperties(), this._buildMethod);
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig config) {
        return Boolean.FALSE;
    }

    protected Object finishBuild(DeserializationContext ctxt, Object builder) throws JacksonException {
        if (null == this._buildMethod) {
            return builder;
        }
        try {
            return this._buildMethod.getMember().invoke(builder, (Object[])null);
        }
        catch (Exception e) {
            return this.wrapInstantiationProblem(ctxt, e);
        }
    }

    @Override
    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        if (p.isExpectedStartObjectToken()) {
            if (this._vanillaProcessing) {
                return this.finishBuild(ctxt, this._vanillaDeserialize(p, ctxt));
            }
            p.nextToken();
            return this.finishBuild(ctxt, this.deserializeFromObject(p, ctxt));
        }
        switch (p.currentTokenId()) {
            case 6: {
                return this.finishBuild(ctxt, this.deserializeFromString(p, ctxt));
            }
            case 7: {
                return this.finishBuild(ctxt, this.deserializeFromNumber(p, ctxt));
            }
            case 8: {
                return this.finishBuild(ctxt, this.deserializeFromDouble(p, ctxt));
            }
            case 12: {
                return p.getEmbeddedObject();
            }
            case 9: 
            case 10: {
                return this.finishBuild(ctxt, this.deserializeFromBoolean(p, ctxt));
            }
            case 3: {
                return this._deserializeFromArray(p, ctxt);
            }
            case 2: 
            case 5: {
                return this.finishBuild(ctxt, this.deserializeFromObject(p, ctxt));
            }
        }
        return ctxt.handleUnexpectedToken(this.getValueType(ctxt), p);
    }

    @Override
    public Object deserialize(JsonParser p, DeserializationContext ctxt, Object value) throws JacksonException {
        Class<?> instRawType;
        JavaType valueType = this._targetType;
        Class<?> builderRawType = this.handledType();
        if (builderRawType.isAssignableFrom(instRawType = value.getClass())) {
            return ctxt.reportBadDefinition(valueType, String.format("Deserialization of %s by passing existing Builder (%s) instance not supported", valueType, builderRawType.getName()));
        }
        return ctxt.reportBadDefinition(valueType, String.format("Deserialization of %s by passing existing instance (of %s) not supported", valueType, instRawType.getName()));
    }

    private final Object _vanillaDeserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        Object builder = this._valueInstantiator.createUsingDefault(ctxt);
        while (true) {
            int ix;
            if ((ix = p.nextNameMatch(this._propertyNameMatcher)) >= 0) {
                p.nextToken();
                SettableBeanProperty prop = this._propertiesByIndex[ix];
                try {
                    builder = prop.deserializeSetAndReturn(p, ctxt, builder);
                }
                catch (Exception e) {
                    throw this.wrapAndThrow(e, builder, prop.getName(), ctxt);
                }
            }
            if (ix == -1) {
                return builder;
            }
            if (ix != -2) break;
            p.nextToken();
            this.handleUnknownVanilla(p, ctxt, builder, p.currentName());
        }
        return this._handleUnexpectedWithin(p, ctxt, builder);
    }

    @Override
    public Object deserializeFromObject(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        Class<?> view;
        if (this._nonStandardCreation) {
            if (this._unwrappedPropertyHandler != null) {
                return this.deserializeWithUnwrapped(p, ctxt);
            }
            if (this._externalTypeIdHandler != null) {
                return this.deserializeWithExternalTypeId(p, ctxt);
            }
            return this.deserializeFromObjectUsingNonDefault(p, ctxt);
        }
        Object bean = this._valueInstantiator.createUsingDefault(ctxt);
        if (this._injectables != null) {
            this.injectValues(ctxt, bean);
        }
        if (this._needViewProcesing && (view = ctxt.getActiveView()) != null) {
            return this.deserializeWithView(p, ctxt, bean, view);
        }
        int ix = p.currentNameMatch(this._propertyNameMatcher);
        while (true) {
            if (ix >= 0) {
                p.nextToken();
                try {
                    bean = this._propertiesByIndex[ix].deserializeSetAndReturn(p, ctxt, bean);
                }
                catch (Exception e) {
                    throw this.wrapAndThrow(e, bean, p.currentName(), ctxt);
                }
            } else {
                if (ix == -1) {
                    return bean;
                }
                if (ix != -2) {
                    return this._handleUnexpectedWithin(p, ctxt, bean);
                }
                p.nextToken();
                this.handleUnknownVanilla(p, ctxt, bean, p.currentName());
            }
            ix = p.nextNameMatch(this._propertyNameMatcher);
        }
    }

    @Override
    protected Object _deserializeUsingPropertyBased(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        Object builder;
        PropertyBasedCreator creator = this._propertyBasedCreator;
        PropertyValueBuffer buffer = creator.startBuilding(p, ctxt, this._objectIdReader);
        Class<?> activeView = this._needViewProcesing ? ctxt.getActiveView() : null;
        TokenBuffer unknown = null;
        JsonToken t = p.currentToken();
        while (t == JsonToken.PROPERTY_NAME) {
            String propName = p.currentName();
            p.nextToken();
            SettableBeanProperty creatorProp = creator.findCreatorProperty(propName);
            if (!buffer.readIdProperty(propName) || creatorProp != null) {
                if (creatorProp != null) {
                    if (activeView != null && !creatorProp.visibleInView(activeView)) {
                        p.skipChildren();
                    } else if (buffer.assignParameter(creatorProp, creatorProp.deserialize(p, ctxt))) {
                        Object builder2;
                        p.nextToken();
                        try {
                            builder2 = creator.build(ctxt, buffer);
                        }
                        catch (Exception e) {
                            throw this.wrapAndThrow(e, this._beanType.getRawClass(), propName, ctxt);
                        }
                        if (builder2.getClass() != this._beanType.getRawClass()) {
                            return this.handlePolymorphic(p, ctxt, builder2, unknown);
                        }
                        if (unknown != null) {
                            builder2 = this.handleUnknownProperties(ctxt, builder2, unknown);
                        }
                        return this._deserialize(p, ctxt, builder2);
                    }
                } else {
                    int ix = this._propertyNameMatcher.matchName(propName);
                    if (ix >= 0) {
                        SettableBeanProperty prop = this._propertiesByIndex[ix];
                        buffer.bufferProperty(prop, prop.deserialize(p, ctxt));
                    } else if (IgnorePropertiesUtil.shouldIgnore(propName, this._ignorableProps, this._includableProps)) {
                        this.handleIgnoredProperty(p, ctxt, this.handledType(), propName);
                    } else if (this._anySetter != null) {
                        buffer.bufferAnyProperty(this._anySetter, propName, this._anySetter.deserialize(p, ctxt));
                    } else {
                        if (unknown == null) {
                            unknown = ctxt.bufferForInputBuffering(p);
                        }
                        unknown.writeName(propName);
                        unknown.copyCurrentStructure(p);
                    }
                }
            }
            t = p.nextToken();
        }
        try {
            builder = creator.build(ctxt, buffer);
        }
        catch (Exception e) {
            builder = this.wrapInstantiationProblem(ctxt, e);
        }
        if (unknown != null) {
            if (builder.getClass() != this._beanType.getRawClass()) {
                return this.handlePolymorphic(null, ctxt, builder, unknown);
            }
            return this.handleUnknownProperties(ctxt, builder, unknown);
        }
        return builder;
    }

    protected final Object _deserialize(JsonParser p, DeserializationContext ctxt, Object builder) throws JacksonException {
        int ix;
        Class<?> view;
        if (this._injectables != null) {
            this.injectValues(ctxt, builder);
        }
        if (this._unwrappedPropertyHandler != null) {
            if (p.hasToken(JsonToken.START_OBJECT)) {
                p.nextToken();
            }
            TokenBuffer tokens = ctxt.bufferForInputBuffering(p);
            tokens.writeStartObject();
            return this.deserializeWithUnwrapped(p, ctxt, builder, tokens);
        }
        if (this._externalTypeIdHandler != null) {
            return this.deserializeWithExternalTypeId(p, ctxt, builder);
        }
        if (this._needViewProcesing && (view = ctxt.getActiveView()) != null) {
            return this.deserializeWithView(p, ctxt, builder, view);
        }
        int n = ix = p.isExpectedStartObjectToken() ? p.nextNameMatch(this._propertyNameMatcher) : p.currentNameMatch(this._propertyNameMatcher);
        while (true) {
            if (ix >= 0) {
                p.nextToken();
                SettableBeanProperty prop = this._propertiesByIndex[ix];
                try {
                    builder = prop.deserializeSetAndReturn(p, ctxt, builder);
                }
                catch (Exception e) {
                    throw this.wrapAndThrow(e, builder, prop.getName(), ctxt);
                }
            } else {
                if (ix == -1) {
                    return builder;
                }
                if (ix != -2) {
                    return this._handleUnexpectedWithin(p, ctxt, builder);
                }
                p.nextToken();
                this.handleUnknownVanilla(p, ctxt, builder, p.currentName());
            }
            ix = p.nextNameMatch(this._propertyNameMatcher);
        }
    }

    @Override
    protected Object _deserializeFromArray(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        ValueDeserializer delegateDeser = this._arrayDelegateDeserializer;
        if (delegateDeser != null || (delegateDeser = this._delegateDeserializer) != null) {
            Object builder = this._valueInstantiator.createUsingArrayDelegate(ctxt, delegateDeser.deserialize(p, ctxt));
            if (this._injectables != null) {
                this.injectValues(ctxt, builder);
            }
            return this.finishBuild(ctxt, builder);
        }
        CoercionAction act = this._findCoercionFromEmptyArray(ctxt);
        boolean unwrap = ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS);
        if (unwrap || act != CoercionAction.Fail) {
            JsonToken t = p.nextToken();
            if (t == JsonToken.END_ARRAY) {
                switch (act) {
                    case AsEmpty: {
                        return this.getEmptyValue(ctxt);
                    }
                    case AsNull: 
                    case TryConvert: {
                        return this.getNullValue(ctxt);
                    }
                }
                return ctxt.handleUnexpectedToken(this.getValueType(ctxt), JsonToken.START_ARRAY, p, null, new Object[0]);
            }
            if (unwrap) {
                Object value = this.deserialize(p, ctxt);
                if (p.nextToken() != JsonToken.END_ARRAY) {
                    this.handleMissingEndArrayForSingle(p, ctxt);
                }
                return value;
            }
        }
        return ctxt.handleUnexpectedToken(this.getValueType(ctxt), p);
    }

    protected final Object deserializeWithView(JsonParser p, DeserializationContext ctxt, Object bean, Class<?> activeView) throws JacksonException {
        int ix = p.currentNameMatch(this._propertyNameMatcher);
        while (true) {
            if (ix >= 0) {
                p.nextToken();
                SettableBeanProperty prop = this._propertiesByIndex[ix];
                if (!prop.visibleInView(activeView)) {
                    if (ctxt.isEnabled(DeserializationFeature.FAIL_ON_UNEXPECTED_VIEW_PROPERTIES)) {
                        ctxt.reportInputMismatch(this.handledType(), String.format("Input mismatch while deserializing %s. Property '%s' is not part of current active view '%s' (disable 'DeserializationFeature.FAIL_ON_UNEXPECTED_VIEW_PROPERTIES' to allow)", ClassUtil.nameOf(this.handledType()), prop.getName(), activeView.getName()), new Object[0]);
                    }
                    p.skipChildren();
                } else {
                    try {
                        bean = prop.deserializeSetAndReturn(p, ctxt, bean);
                    }
                    catch (Exception e) {
                        throw this.wrapAndThrow(e, bean, prop.getName(), ctxt);
                    }
                }
            } else if (ix != -1) {
                if (ix != -2) {
                    return this._handleUnexpectedWithin(p, ctxt, bean);
                }
                p.nextToken();
                this.handleUnknownVanilla(p, ctxt, bean, p.currentName());
            } else {
                return bean;
            }
            ix = p.nextNameMatch(this._propertyNameMatcher);
        }
    }

    protected Object deserializeWithUnwrapped(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        if (this._delegateDeserializer != null) {
            return this._valueInstantiator.createUsingDelegate(ctxt, this._delegateDeserializer.deserialize(p, ctxt));
        }
        if (this._propertyBasedCreator != null) {
            return this.deserializeUsingPropertyBasedWithUnwrapped(p, ctxt);
        }
        TokenBuffer tokens = ctxt.bufferForInputBuffering(p);
        tokens.writeStartObject();
        Object bean = this._valueInstantiator.createUsingDefault(ctxt);
        if (this._injectables != null) {
            this.injectValues(ctxt, bean);
        }
        Class<?> activeView = this._needViewProcesing ? ctxt.getActiveView() : null;
        int ix = p.currentNameMatch(this._propertyNameMatcher);
        while (true) {
            if (ix >= 0) {
                p.nextToken();
                SettableBeanProperty prop = this._propertiesByIndex[ix];
                if (activeView != null && !prop.visibleInView(activeView)) {
                    p.skipChildren();
                } else {
                    try {
                        bean = prop.deserializeSetAndReturn(p, ctxt, bean);
                    }
                    catch (Exception e) {
                        throw this.wrapAndThrow(e, bean, prop.getName(), ctxt);
                    }
                }
            } else {
                if (ix == -1) break;
                if (ix == -3) {
                    return this._handleUnexpectedWithin(p, ctxt, bean);
                }
                String propName = p.currentName();
                p.nextToken();
                if (IgnorePropertiesUtil.shouldIgnore(propName, this._ignorableProps, this._includableProps)) {
                    this.handleIgnoredProperty(p, ctxt, bean, propName);
                } else {
                    tokens.writeName(propName);
                    tokens.copyCurrentStructure(p);
                    if (this._anySetter != null) {
                        try {
                            this._anySetter.deserializeAndSet(p, ctxt, bean, propName);
                        }
                        catch (Exception e) {
                            throw this.wrapAndThrow(e, bean, propName, ctxt);
                        }
                    }
                }
            }
            ix = p.nextNameMatch(this._propertyNameMatcher);
        }
        tokens.writeEndObject();
        return this._unwrappedPropertyHandler.processUnwrapped(p, ctxt, bean, tokens);
    }

    protected Object deserializeWithUnwrapped(JsonParser p, DeserializationContext ctxt, Object builder, TokenBuffer tokens) throws JacksonException {
        Class<?> activeView = this._needViewProcesing ? ctxt.getActiveView() : null;
        int ix = p.currentNameMatch(this._propertyNameMatcher);
        while (true) {
            if (ix >= 0) {
                p.nextToken();
                SettableBeanProperty prop = this._propertiesByIndex[ix];
                if (activeView != null && !prop.visibleInView(activeView)) {
                    p.skipChildren();
                } else {
                    try {
                        builder = prop.deserializeSetAndReturn(p, ctxt, builder);
                    }
                    catch (Exception e) {
                        this.wrapAndThrow(e, builder, prop.getName(), ctxt);
                    }
                }
            } else {
                if (ix == -1) break;
                if (ix == -3) {
                    return this._handleUnexpectedWithin(p, ctxt, builder);
                }
                String propName = p.currentName();
                p.nextToken();
                if (this._ignorableProps != null && this._ignorableProps.contains(propName)) {
                    this.handleIgnoredProperty(p, ctxt, builder, propName);
                } else {
                    tokens.writeName(propName);
                    tokens.copyCurrentStructure(p);
                    if (this._anySetter != null) {
                        this._anySetter.deserializeAndSet(p, ctxt, builder, propName);
                    }
                }
            }
            ix = p.nextNameMatch(this._propertyNameMatcher);
        }
        tokens.writeEndObject();
        return this._unwrappedPropertyHandler.processUnwrapped(p, ctxt, builder, tokens);
    }

    protected Object deserializeUsingPropertyBasedWithUnwrapped(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        PropertyBasedCreator creator = this._propertyBasedCreator;
        PropertyValueBuffer buffer = creator.startBuilding(p, ctxt, this._objectIdReader);
        TokenBuffer tokens = ctxt.bufferForInputBuffering(p);
        tokens.writeStartObject();
        JsonToken t = p.currentToken();
        while (t == JsonToken.PROPERTY_NAME) {
            String propName = p.currentName();
            p.nextToken();
            SettableBeanProperty creatorProp = creator.findCreatorProperty(propName);
            if (!buffer.readIdProperty(propName) || creatorProp != null) {
                if (creatorProp != null) {
                    if (buffer.assignParameter(creatorProp, creatorProp.deserialize(p, ctxt))) {
                        t = p.nextToken();
                        Object builder = null;
                        try {
                            builder = creator.build(ctxt, buffer);
                        }
                        catch (Exception e) {
                            throw this.wrapAndThrow(e, this._beanType.getRawClass(), propName, ctxt);
                        }
                        if (builder.getClass() != this._beanType.getRawClass()) {
                            return this.handlePolymorphic(p, ctxt, builder, tokens);
                        }
                        return this.deserializeWithUnwrapped(p, ctxt, builder, tokens);
                    }
                } else {
                    int ix = this._propertyNameMatcher.matchName(propName);
                    if (ix >= 0) {
                        SettableBeanProperty prop = this._propertiesByIndex[ix];
                        buffer.bufferProperty(prop, prop.deserialize(p, ctxt));
                    } else if (IgnorePropertiesUtil.shouldIgnore(propName, this._ignorableProps, this._includableProps)) {
                        this.handleIgnoredProperty(p, ctxt, this.handledType(), propName);
                    } else {
                        tokens.writeName(propName);
                        tokens.copyCurrentStructure(p);
                        if (this._anySetter != null) {
                            buffer.bufferAnyProperty(this._anySetter, propName, this._anySetter.deserialize(p, ctxt));
                        }
                    }
                }
            }
            t = p.nextToken();
        }
        tokens.writeEndObject();
        Object builder = null;
        try {
            builder = creator.build(ctxt, buffer);
        }
        catch (Exception e) {
            return this.wrapInstantiationProblem(ctxt, e);
        }
        return this._unwrappedPropertyHandler.processUnwrapped(p, ctxt, builder, tokens);
    }

    protected Object deserializeWithExternalTypeId(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        if (this._propertyBasedCreator != null) {
            return this.deserializeUsingPropertyBasedWithExternalTypeId(p, ctxt);
        }
        return this.deserializeWithExternalTypeId(p, ctxt, this._valueInstantiator.createUsingDefault(ctxt));
    }

    protected Object deserializeWithExternalTypeId(JsonParser p, DeserializationContext ctxt, Object bean) throws JacksonException {
        Class<?> activeView = this._needViewProcesing ? ctxt.getActiveView() : null;
        ExternalTypeHandler ext = this._externalTypeIdHandler.start();
        int ix = p.currentNameMatch(this._propertyNameMatcher);
        while (true) {
            if (ix >= 0) {
                SettableBeanProperty prop = this._propertiesByIndex[ix];
                JsonToken t = p.nextToken();
                if (t.isScalarValue()) {
                    ext.handleTypePropertyValue(p, ctxt, p.currentName(), bean);
                }
                if (activeView != null && !prop.visibleInView(activeView)) {
                    p.skipChildren();
                } else {
                    try {
                        bean = prop.deserializeSetAndReturn(p, ctxt, bean);
                    }
                    catch (Exception e) {
                        throw this.wrapAndThrow(e, bean, prop.getName(), ctxt);
                    }
                }
            } else {
                if (ix == -1) break;
                if (ix != -2) {
                    return this._handleUnexpectedWithin(p, ctxt, bean);
                }
                String propName = p.currentName();
                if (IgnorePropertiesUtil.shouldIgnore(propName, this._ignorableProps, this._includableProps)) {
                    this.handleIgnoredProperty(p, ctxt, bean, propName);
                } else if (!ext.handlePropertyValue(p, ctxt, propName, bean)) {
                    if (this._anySetter != null) {
                        try {
                            this._anySetter.deserializeAndSet(p, ctxt, bean, propName);
                        }
                        catch (Exception e) {
                            throw this.wrapAndThrow(e, bean, propName, ctxt);
                        }
                    } else {
                        this.handleUnknownProperty(p, ctxt, bean, propName);
                    }
                }
            }
            ix = p.nextNameMatch(this._propertyNameMatcher);
        }
        return ext.complete(p, ctxt, bean);
    }

    protected Object deserializeUsingPropertyBasedWithExternalTypeId(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        JavaType t = this._targetType;
        return ctxt.reportBadDefinition(t, String.format("Deserialization (of %s) with Builder, External type id, @JsonCreator not yet implemented", t));
    }

    protected Object _handleUnexpectedWithin(JsonParser p, DeserializationContext ctxt, Object beanOrBuilder) throws JacksonException {
        return ctxt.handleUnexpectedToken(this.getValueType(ctxt), p);
    }
}

