/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.catalina.Context;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.SessionEvent;
import org.apache.catalina.SessionListener;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.session.StandardSessionContext;
import org.apache.catalina.session.StandardSessionFacade;
import org.apache.catalina.util.Enumerator;
import org.apache.catalina.util.StringManager;

public class StandardSession
implements HttpSession,
Session,
Serializable {
    protected static final String[] EMPTY_ARRAY = new String[0];
    protected static final String NOT_SERIALIZED = "___NOT_SERIALIZABLE_EXCEPTION___";
    protected Map attributes = new Hashtable();
    protected transient String authType = null;
    protected transient Method containerEventMethod = null;
    protected static final Class[] containerEventTypes = new Class[]{String.class, Object.class};
    protected long creationTime = 0L;
    private static final String[] excludedAttributes = new String[]{"javax.security.auth.subject"};
    protected transient boolean expiring = false;
    protected transient StandardSessionFacade facade = null;
    protected String id = null;
    protected static final String info = "StandardSession/1.0";
    protected long lastAccessedTime = this.creationTime;
    protected transient ArrayList listeners = new ArrayList();
    protected transient Manager manager = null;
    protected int maxInactiveInterval = -1;
    protected boolean isNew = false;
    protected boolean isValid = false;
    protected transient Map notes = new Hashtable();
    protected transient Principal principal = null;
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.session");
    protected static HttpSessionContext sessionContext = null;
    protected transient PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected long thisAccessedTime = this.creationTime;
    protected transient int accessCount = 0;

    public StandardSession(Manager manager) {
        this.manager = manager;
    }

    public String getAuthType() {
        return this.authType;
    }

    public void setAuthType(String authType) {
        String oldAuthType = this.authType;
        this.authType = authType;
        this.support.firePropertyChange("authType", oldAuthType, this.authType);
    }

    public void setCreationTime(long time) {
        this.creationTime = time;
        this.lastAccessedTime = time;
        this.thisAccessedTime = time;
    }

    public String getId() {
        if (!this.isValid()) {
            throw new IllegalStateException(sm.getString("standardSession.getId.ise"));
        }
        return this.id;
    }

    public String getIdInternal() {
        return this.id;
    }

    public void setId(String id) {
        if (this.id != null && this.manager != null) {
            this.manager.remove(this);
        }
        this.id = id;
        if (this.manager != null) {
            this.manager.add(this);
        }
        this.tellNew();
    }

    public void tellNew() {
        this.fireSessionEvent("createSession", null);
        Context context = (Context)this.manager.getContainer();
        Object[] listeners = context.getApplicationLifecycleListeners();
        if (listeners != null) {
            HttpSessionEvent event = new HttpSessionEvent(this.getSession());
            for (int i = 0; i < listeners.length; ++i) {
                if (!(listeners[i] instanceof HttpSessionListener)) continue;
                HttpSessionListener listener = (HttpSessionListener)listeners[i];
                try {
                    this.fireContainerEvent(context, "beforeSessionCreated", listener);
                    listener.sessionCreated(event);
                    this.fireContainerEvent(context, "afterSessionCreated", listener);
                    continue;
                }
                catch (Throwable t) {
                    try {
                        this.fireContainerEvent(context, "afterSessionCreated", listener);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.manager.getContainer().getLogger().error((Object)sm.getString("standardSession.sessionEvent"), t);
                }
            }
        }
    }

    public String getInfo() {
        return info;
    }

    public long getLastAccessedTime() {
        if (!this.isValid()) {
            throw new IllegalStateException(sm.getString("standardSession.getLastAccessedTime.ise"));
        }
        return this.lastAccessedTime;
    }

    public Manager getManager() {
        return this.manager;
    }

    public void setManager(Manager manager) {
        this.manager = manager;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public void setMaxInactiveInterval(int interval) {
        this.maxInactiveInterval = interval;
        if (this.isValid && interval == 0) {
            this.expire();
        }
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(Principal principal) {
        Principal oldPrincipal = this.principal;
        this.principal = principal;
        this.support.firePropertyChange("principal", oldPrincipal, this.principal);
    }

    public HttpSession getSession() {
        if (this.facade == null) {
            if (SecurityUtil.isPackageProtectionEnabled()) {
                final StandardSession fsession = this;
                this.facade = (StandardSessionFacade)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new StandardSessionFacade(fsession);
                    }
                });
            } else {
                this.facade = new StandardSessionFacade(this);
            }
        }
        return this.facade;
    }

    public boolean isValid() {
        long timeNow;
        int timeIdle;
        if (this.expiring) {
            return true;
        }
        if (!this.isValid) {
            return false;
        }
        if (this.accessCount > 0) {
            return true;
        }
        if (this.maxInactiveInterval >= 0 && (timeIdle = (int)(((timeNow = System.currentTimeMillis()) - this.thisAccessedTime) / 1000L)) >= this.maxInactiveInterval) {
            this.expire(true);
        }
        return this.isValid;
    }

    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    public void access() {
        this.lastAccessedTime = this.thisAccessedTime;
        this.thisAccessedTime = System.currentTimeMillis();
        this.evaluateIfValid();
        ++this.accessCount;
    }

    public void endAccess() {
        this.isNew = false;
        --this.accessCount;
    }

    public void addSessionListener(SessionListener listener) {
        this.listeners.add(listener);
    }

    public void expire() {
        this.expire(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expire(boolean notify) {
        if (this.expiring) {
            return;
        }
        StandardSession standardSession = this;
        synchronized (standardSession) {
            Manager listener;
            if (this.manager == null) {
                return;
            }
            this.expiring = true;
            Context context = (Context)this.manager.getContainer();
            Object[] listeners = context.getApplicationLifecycleListeners();
            if (notify && listeners != null) {
                HttpSessionEvent event = new HttpSessionEvent(this.getSession());
                for (int i = 0; i < listeners.length; ++i) {
                    int j = listeners.length - 1 - i;
                    if (!(listeners[j] instanceof HttpSessionListener)) continue;
                    listener = (HttpSessionListener)listeners[j];
                    try {
                        this.fireContainerEvent(context, "beforeSessionDestroyed", listener);
                        listener.sessionDestroyed(event);
                        this.fireContainerEvent(context, "afterSessionDestroyed", listener);
                        continue;
                    }
                    catch (Throwable t) {
                        try {
                            this.fireContainerEvent(context, "afterSessionDestroyed", listener);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        this.manager.getContainer().getLogger().error((Object)sm.getString("standardSession.sessionEvent"), t);
                    }
                }
            }
            this.accessCount = 0;
            this.setValid(false);
            long timeNow = System.currentTimeMillis();
            int timeAlive = (int)((timeNow - this.creationTime) / 1000L);
            listener = this.manager;
            synchronized (listener) {
                if (timeAlive > this.manager.getSessionMaxAliveTime()) {
                    this.manager.setSessionMaxAliveTime(timeAlive);
                }
                int numExpired = this.manager.getExpiredSessions();
                this.manager.setExpiredSessions(++numExpired);
                int average = this.manager.getSessionAverageAliveTime();
                average = (average * (numExpired - 1) + timeAlive) / numExpired;
                this.manager.setSessionAverageAliveTime(average);
            }
            this.manager.remove(this);
            if (notify) {
                this.fireSessionEvent("destroySession", null);
            }
            this.expiring = false;
            String[] keys = this.keys();
            for (int i = 0; i < keys.length; ++i) {
                this.removeAttributeInternal(keys[i], notify);
            }
        }
    }

    public void passivate() {
        this.fireSessionEvent("passivateSession", null);
        HttpSessionEvent event = null;
        String[] keys = this.keys();
        for (int i = 0; i < keys.length; ++i) {
            Object attribute = this.attributes.get(keys[i]);
            if (!(attribute instanceof HttpSessionActivationListener)) continue;
            if (event == null) {
                event = new HttpSessionEvent(this.getSession());
            }
            try {
                ((HttpSessionActivationListener)attribute).sessionWillPassivate(event);
                continue;
            }
            catch (Throwable t) {
                this.manager.getContainer().getLogger().error((Object)sm.getString("standardSession.attributeEvent"), t);
            }
        }
    }

    public void activate() {
        this.fireSessionEvent("activateSession", null);
        HttpSessionEvent event = null;
        String[] keys = this.keys();
        for (int i = 0; i < keys.length; ++i) {
            Object attribute = this.attributes.get(keys[i]);
            if (!(attribute instanceof HttpSessionActivationListener)) continue;
            if (event == null) {
                event = new HttpSessionEvent(this.getSession());
            }
            try {
                ((HttpSessionActivationListener)attribute).sessionDidActivate(event);
                continue;
            }
            catch (Throwable t) {
                this.manager.getContainer().getLogger().error((Object)sm.getString("standardSession.attributeEvent"), t);
            }
        }
    }

    public Object getNote(String name) {
        return this.notes.get(name);
    }

    public Iterator getNoteNames() {
        return this.notes.keySet().iterator();
    }

    public void recycle() {
        this.attributes.clear();
        this.setAuthType(null);
        this.creationTime = 0L;
        this.expiring = false;
        this.id = null;
        this.lastAccessedTime = 0L;
        this.maxInactiveInterval = -1;
        this.accessCount = 0;
        this.notes.clear();
        this.setPrincipal(null);
        this.isNew = false;
        this.isValid = false;
        this.manager = null;
    }

    public void removeNote(String name) {
        this.notes.remove(name);
    }

    public void removeSessionListener(SessionListener listener) {
        this.listeners.remove(listener);
    }

    public void setNote(String name, Object value) {
        this.notes.put(name, value);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("StandardSession[");
        sb.append(this.id);
        sb.append("]");
        return sb.toString();
    }

    public void readObjectData(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        this.readObject(stream);
    }

    public void writeObjectData(ObjectOutputStream stream) throws IOException {
        this.writeObject(stream);
    }

    public long getCreationTime() {
        if (!this.isValid()) {
            throw new IllegalStateException(sm.getString("standardSession.getCreationTime.ise"));
        }
        return this.creationTime;
    }

    public ServletContext getServletContext() {
        if (this.manager == null) {
            return null;
        }
        Context context = (Context)this.manager.getContainer();
        if (context == null) {
            return null;
        }
        return context.getServletContext();
    }

    public HttpSessionContext getSessionContext() {
        if (sessionContext == null) {
            sessionContext = new StandardSessionContext();
        }
        return sessionContext;
    }

    public Object getAttribute(String name) {
        if (!this.isValid()) {
            throw new IllegalStateException(sm.getString("standardSession.getAttribute.ise"));
        }
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        if (!this.isValid()) {
            throw new IllegalStateException(sm.getString("standardSession.getAttributeNames.ise"));
        }
        return new Enumerator(this.attributes.keySet(), true);
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public String[] getValueNames() {
        if (!this.isValid()) {
            throw new IllegalStateException(sm.getString("standardSession.getValueNames.ise"));
        }
        return this.keys();
    }

    public void invalidate() {
        if (!this.isValid()) {
            throw new IllegalStateException(sm.getString("standardSession.invalidate.ise"));
        }
        this.expire();
    }

    public boolean isNew() {
        if (!this.isValid()) {
            throw new IllegalStateException(sm.getString("standardSession.isNew.ise"));
        }
        return this.isNew;
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.removeAttribute(name, true);
    }

    public void removeAttribute(String name, boolean notify) {
        if (!this.isValid()) {
            throw new IllegalStateException(sm.getString("standardSession.removeAttribute.ise"));
        }
        this.removeAttributeInternal(name, notify);
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        Context context;
        Object[] listeners;
        Object unbound;
        Object oldValue;
        if (name == null) {
            throw new IllegalArgumentException(sm.getString("standardSession.setAttribute.namenull"));
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        if (!this.isValid()) {
            throw new IllegalStateException(sm.getString("standardSession.setAttribute.ise"));
        }
        if (this.manager != null && this.manager.getDistributable() && !(value instanceof Serializable)) {
            throw new IllegalArgumentException(sm.getString("standardSession.setAttribute.iae"));
        }
        HttpSessionBindingEvent event = null;
        if (value instanceof HttpSessionBindingListener && value != (oldValue = this.attributes.get(name))) {
            event = new HttpSessionBindingEvent(this.getSession(), name, value);
            try {
                ((HttpSessionBindingListener)value).valueBound(event);
            }
            catch (Throwable t) {
                this.manager.getContainer().getLogger().error((Object)sm.getString("standardSession.bindingEvent"), t);
            }
        }
        if ((unbound = this.attributes.put(name, value)) != null && unbound != value && unbound instanceof HttpSessionBindingListener) {
            try {
                ((HttpSessionBindingListener)unbound).valueUnbound(new HttpSessionBindingEvent(this.getSession(), name));
            }
            catch (Throwable t) {
                this.manager.getContainer().getLogger().error((Object)sm.getString("standardSession.bindingEvent"), t);
            }
        }
        if ((listeners = (context = (Context)this.manager.getContainer()).getApplicationEventListeners()) == null) {
            return;
        }
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof HttpSessionAttributeListener)) continue;
            HttpSessionAttributeListener listener = (HttpSessionAttributeListener)listeners[i];
            try {
                if (unbound != null) {
                    this.fireContainerEvent(context, "beforeSessionAttributeReplaced", listener);
                    if (event == null) {
                        event = new HttpSessionBindingEvent(this.getSession(), name, unbound);
                    }
                    listener.attributeReplaced(event);
                    this.fireContainerEvent(context, "afterSessionAttributeReplaced", listener);
                    continue;
                }
                this.fireContainerEvent(context, "beforeSessionAttributeAdded", listener);
                if (event == null) {
                    event = new HttpSessionBindingEvent(this.getSession(), name, value);
                }
                listener.attributeAdded(event);
                this.fireContainerEvent(context, "afterSessionAttributeAdded", listener);
                continue;
            }
            catch (Throwable t) {
                try {
                    if (unbound != null) {
                        this.fireContainerEvent(context, "afterSessionAttributeReplaced", listener);
                    } else {
                        this.fireContainerEvent(context, "afterSessionAttributeAdded", listener);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.manager.getContainer().getLogger().error((Object)sm.getString("standardSession.attributeEvent"), t);
            }
        }
    }

    private void readObject(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        this.authType = null;
        this.creationTime = (Long)stream.readObject();
        this.lastAccessedTime = (Long)stream.readObject();
        this.maxInactiveInterval = (Integer)stream.readObject();
        this.isNew = (Boolean)stream.readObject();
        this.isValid = (Boolean)stream.readObject();
        this.thisAccessedTime = (Long)stream.readObject();
        this.principal = null;
        this.id = (String)stream.readObject();
        if (this.manager.getContainer().getLogger().isDebugEnabled()) {
            this.manager.getContainer().getLogger().debug((Object)("readObject() loading session " + this.id));
        }
        if (this.attributes == null) {
            this.attributes = new Hashtable();
        }
        int n = (Integer)stream.readObject();
        boolean isValidSave = this.isValid;
        this.isValid = true;
        for (int i = 0; i < n; ++i) {
            String name = (String)stream.readObject();
            Object value = stream.readObject();
            if (value instanceof String && value.equals(NOT_SERIALIZED)) continue;
            if (this.manager.getContainer().getLogger().isDebugEnabled()) {
                this.manager.getContainer().getLogger().debug((Object)("  loading attribute '" + name + "' with value '" + value + "'"));
            }
            this.attributes.put(name, value);
        }
        this.isValid = isValidSave;
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        if (this.notes == null) {
            this.notes = new Hashtable();
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(new Long(this.creationTime));
        stream.writeObject(new Long(this.lastAccessedTime));
        stream.writeObject(new Integer(this.maxInactiveInterval));
        stream.writeObject(new Boolean(this.isNew));
        stream.writeObject(new Boolean(this.isValid));
        stream.writeObject(new Long(this.thisAccessedTime));
        stream.writeObject(this.id);
        if (this.manager.getContainer().getLogger().isDebugEnabled()) {
            this.manager.getContainer().getLogger().debug((Object)("writeObject() storing session " + this.id));
        }
        String[] keys = this.keys();
        ArrayList<String> saveNames = new ArrayList<String>();
        ArrayList saveValues = new ArrayList();
        for (int i = 0; i < keys.length; ++i) {
            Object value = this.attributes.get(keys[i]);
            if (value == null) continue;
            if (value instanceof Serializable && !this.exclude(keys[i])) {
                saveNames.add(keys[i]);
                saveValues.add(value);
                continue;
            }
            this.removeAttributeInternal(keys[i], true);
        }
        int n = saveNames.size();
        stream.writeObject(new Integer(n));
        for (int i = 0; i < n; ++i) {
            stream.writeObject((String)saveNames.get(i));
            try {
                stream.writeObject(saveValues.get(i));
                if (!this.manager.getContainer().getLogger().isDebugEnabled()) continue;
                this.manager.getContainer().getLogger().debug((Object)("  storing attribute '" + saveNames.get(i) + "' with value '" + saveValues.get(i) + "'"));
                continue;
            }
            catch (NotSerializableException e) {
                this.manager.getContainer().getLogger().warn((Object)sm.getString("standardSession.notSerializable", saveNames.get(i), this.id), (Throwable)e);
                stream.writeObject(NOT_SERIALIZED);
                if (!this.manager.getContainer().getLogger().isDebugEnabled()) continue;
                this.manager.getContainer().getLogger().debug((Object)("  storing attribute '" + saveNames.get(i) + "' with value NOT_SERIALIZED"));
            }
        }
    }

    protected boolean exclude(String name) {
        for (int i = 0; i < excludedAttributes.length; ++i) {
            if (!name.equalsIgnoreCase(excludedAttributes[i])) continue;
            return true;
        }
        return false;
    }

    protected void evaluateIfValid() {
        if (!this.isValid || this.expiring || this.maxInactiveInterval < 0) {
            return;
        }
        this.isValid();
    }

    protected void fireContainerEvent(Context context, String type, Object data) throws Exception {
        if (!"org.apache.catalina.core.StandardContext".equals(context.getClass().getName())) {
            return;
        }
        if (this.containerEventMethod == null) {
            this.containerEventMethod = context.getClass().getMethod("fireContainerEvent", containerEventTypes);
        }
        Object[] containerEventParams = new Object[]{type, data};
        this.containerEventMethod.invoke((Object)context, containerEventParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireSessionEvent(String type, Object data) {
        if (this.listeners.size() < 1) {
            return;
        }
        SessionEvent event = new SessionEvent(this, type, data);
        SessionListener[] list = new SessionListener[]{};
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            list = this.listeners.toArray(list);
        }
        for (int i = 0; i < list.length; ++i) {
            list[i].sessionEvent(event);
        }
    }

    protected String[] keys() {
        return this.attributes.keySet().toArray(EMPTY_ARRAY);
    }

    protected void removeAttributeInternal(String name, boolean notify) {
        Context context;
        Object[] listeners;
        Object value = this.attributes.remove(name);
        if (!notify || value == null) {
            return;
        }
        HttpSessionBindingEvent event = null;
        if (value instanceof HttpSessionBindingListener) {
            event = new HttpSessionBindingEvent(this.getSession(), name, value);
            ((HttpSessionBindingListener)value).valueUnbound(event);
        }
        if ((listeners = (context = (Context)this.manager.getContainer()).getApplicationEventListeners()) == null) {
            return;
        }
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof HttpSessionAttributeListener)) continue;
            HttpSessionAttributeListener listener = (HttpSessionAttributeListener)listeners[i];
            try {
                this.fireContainerEvent(context, "beforeSessionAttributeRemoved", listener);
                if (event == null) {
                    event = new HttpSessionBindingEvent(this.getSession(), name, value);
                }
                listener.attributeRemoved(event);
                this.fireContainerEvent(context, "afterSessionAttributeRemoved", listener);
                continue;
            }
            catch (Throwable t) {
                try {
                    this.fireContainerEvent(context, "afterSessionAttributeRemoved", listener);
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.manager.getContainer().getLogger().error((Object)sm.getString("standardSession.attributeEvent"), t);
            }
        }
    }
}

