/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javax.measure.Dimension;
import javax.measure.IncommensurableException;
import javax.measure.Prefix;
import javax.measure.Quantity;
import javax.measure.UnconvertibleException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Dimensionless;
import javax.measure.spi.SystemOfUnits;
import org.apiguardian.api.API;
import tech.units.indriya.format.SimpleUnitFormat;
import tech.units.indriya.function.AbstractConverter;
import tech.units.indriya.function.AddConverter;
import tech.units.indriya.function.Calculus;
import tech.units.indriya.function.MultiplyConverter;
import tech.units.indriya.function.RationalNumber;
import tech.units.indriya.internal.function.Calculator;
import tech.units.indriya.spi.DimensionalModel;
import tech.units.indriya.unit.AlternateUnit;
import tech.units.indriya.unit.AnnotatedUnit;
import tech.units.indriya.unit.ProductUnit;
import tech.units.indriya.unit.TransformedUnit;
import tech.units.indriya.unit.Units;
import tech.uom.lib.common.function.Nameable;
import tech.uom.lib.common.function.PrefixOperator;
import tech.uom.lib.common.function.SymbolSupplier;

public abstract class AbstractUnit<Q extends Quantity<Q>>
implements Unit<Q>,
Comparable<Unit<Q>>,
PrefixOperator<Q>,
Nameable,
Serializable,
SymbolSupplier {
    private static final long serialVersionUID = -4344589505537030204L;
    public static final Unit<Dimensionless> ONE = new ProductUnit<Dimensionless>();
    private String name;
    private String symbol;
    protected Quantity.Scale scale = Quantity.Scale.ABSOLUTE;
    protected static final transient Map<String, Unit<?>> SYMBOL_TO_UNIT = new HashMap();

    protected AbstractUnit() {
    }

    protected AbstractUnit(String symbol) {
        this.symbol = symbol;
    }

    protected Type getActualType() {
        ParameterizedType parameterizedType = (ParameterizedType)this.getClass().getGenericSuperclass();
        return parameterizedType.getActualTypeArguments()[0].getClass().getGenericInterfaces()[0];
    }

    public boolean isSystemUnit() {
        Unit<Q> sys = this.toSystemUnit();
        return this == sys || this.equals(sys);
    }

    public abstract UnitConverter getSystemConverter();

    protected abstract Unit<Q> toSystemUnit();

    public final Unit<Q> annotate(String annotation) {
        return new AnnotatedUnit(this, annotation);
    }

    public static Unit<?> parse(CharSequence charSequence) {
        return SimpleUnitFormat.getInstance().parse(charSequence);
    }

    public String toString() {
        return SimpleUnitFormat.getInstance().format(this);
    }

    public final Unit<Q> getSystemUnit() {
        return this.toSystemUnit();
    }

    public final boolean isCompatible(Unit<?> that) {
        return this.internalIsCompatible(that, true);
    }

    public final <T extends Quantity<T>> Unit<T> asType(Class<T> type) {
        return this.asType(type, Units.getInstance());
    }

    public abstract Map<? extends Unit<?>, Integer> getBaseUnits();

    public abstract Dimension getDimension();

    protected void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getSymbol() {
        return this.symbol;
    }

    protected void setSymbol(String s) {
        this.symbol = s;
    }

    public final UnitConverter getConverterTo(Unit<Q> that) throws UnconvertibleException {
        return this.internalGetConverterTo(that, true);
    }

    public final UnitConverter getConverterToAny(Unit<?> that) throws IncommensurableException, UnconvertibleException {
        return this.getConverterToAny(that, Quantity.Scale.ABSOLUTE);
    }

    public final <T extends Quantity<T>> Unit<T> asType(Class<T> type, SystemOfUnits typeSystem) {
        Dimension typeDimension;
        Unit typedUnit = typeSystem.getUnit(type);
        Dimension dimension = typeDimension = typedUnit != null ? typedUnit.getDimension() : null;
        if (typeDimension != null && !typeDimension.equals(this.getDimension())) {
            throw new ClassCastException("The unit: " + this + " is not compatible with quantities of type " + type);
        }
        return this;
    }

    @API(status=API.Status.EXPERIMENTAL)
    public final UnitConverter getConverterTo(Unit<Q> that, Quantity.Scale scale) throws UnconvertibleException {
        this.scale = scale;
        return this.getConverterTo(that);
    }

    @API(status=API.Status.EXPERIMENTAL)
    public final UnitConverter getConverterToAny(Unit<?> that, Quantity.Scale scale) throws IncommensurableException, UnconvertibleException {
        if (!this.isCompatible(that)) {
            throw new IncommensurableException(this + " is not compatible with " + that);
        }
        this.scale = scale;
        AbstractUnit thatAbstr = (AbstractUnit)that;
        DimensionalModel model = DimensionalModel.current();
        Unit<Q> thisSystemUnit = this.getSystemUnit();
        UnitConverter thisToDimension = model.getDimensionalTransform(thisSystemUnit.getDimension()).concatenate(this.getSystemConverter());
        Unit<Q> thatSystemUnit = thatAbstr.getSystemUnit();
        UnitConverter thatToDimension = model.getDimensionalTransform(thatSystemUnit.getDimension()).concatenate(thatAbstr.getSystemConverter());
        return thatToDimension.inverse().concatenate(thisToDimension);
    }

    public final Unit<Q> alternate(String newSymbol) {
        return new AlternateUnit(this, newSymbol);
    }

    public final Unit<Q> transform(UnitConverter operation) {
        TransformedUnit systemUnit = this.getSystemUnit();
        UnitConverter cvtr = this.isSystemUnit() ? this.getSystemConverter().concatenate(operation) : operation;
        return cvtr.isIdentity() ? systemUnit : new TransformedUnit(null, this, systemUnit, cvtr);
    }

    public final Unit<Q> shift(Number offset) {
        if (Calculus.currentNumberSystem().isZero(offset)) {
            return this;
        }
        return this.transform(new AddConverter(offset));
    }

    public final Unit<Q> multiply(Number factor) {
        if (Calculus.currentNumberSystem().isOne(factor)) {
            return this;
        }
        return this.transform(MultiplyConverter.of(factor));
    }

    public Unit<Q> shift(double offset) {
        return this.shift(RationalNumber.of(offset));
    }

    public Unit<Q> multiply(double multiplier) {
        return this.multiply(RationalNumber.of(multiplier));
    }

    public Unit<Q> divide(double divisor) {
        return this.divide(RationalNumber.of(divisor));
    }

    private final boolean internalIsCompatible(Unit<?> that, boolean checkEquals) {
        Dimension thatDimension;
        if (checkEquals ? this == that || this.equals(that) : this == that) {
            return true;
        }
        if (!(that instanceof Unit)) {
            return false;
        }
        Dimension thisDimension = this.getDimension();
        if (thisDimension.equals(thatDimension = that.getDimension())) {
            return true;
        }
        DimensionalModel model = DimensionalModel.current();
        return model.getFundamentalDimension(thisDimension).equals(model.getFundamentalDimension(thatDimension));
    }

    protected final UnitConverter internalGetConverterTo(Unit<Q> that, boolean useEquals) throws UnconvertibleException {
        Unit thatSystemUnit;
        if (useEquals ? this == that || this.equals(that) : this == that) {
            return AbstractConverter.IDENTITY;
        }
        Unit<Q> thisSystemUnit = this.getSystemUnit();
        if (!thisSystemUnit.equals((Object)(thatSystemUnit = that.getSystemUnit()))) {
            try {
                return this.getConverterToAny(that);
            }
            catch (IncommensurableException e) {
                throw new UnconvertibleException((Throwable)e);
            }
        }
        UnitConverter thisToSI = this.getSystemConverter();
        UnitConverter thatToSI = that.getConverterTo(thatSystemUnit);
        return thatToSI.inverse().concatenate(thisToSI);
    }

    public final Unit<?> multiply(Unit<?> that) {
        if (this.equals(ONE)) {
            return that;
        }
        if (that.equals(ONE)) {
            return this;
        }
        return ProductUnit.ofProduct(this, that);
    }

    public final Unit<?> inverse() {
        if (this.equals(ONE)) {
            return this;
        }
        return ProductUnit.ofQuotient(ONE, this);
    }

    public final Unit<Q> divide(Number divisor) {
        if (Calculus.currentNumberSystem().isOne(divisor)) {
            return this;
        }
        Number factor = Calculator.of(divisor).reciprocal().peek();
        return this.transform(MultiplyConverter.of(factor));
    }

    public final Unit<?> divide(Unit<?> that) {
        return this.multiply(that.inverse());
    }

    public final Unit<?> root(int n) {
        if (n > 0) {
            return ProductUnit.ofRoot(this, n);
        }
        if (n == 0) {
            throw new ArithmeticException("Root's order of zero");
        }
        return ONE.divide(this.root(-n));
    }

    public Unit<?> pow(int n) {
        if (n > 0) {
            return this.multiply(this.pow(n - 1));
        }
        if (n == 0) {
            return ONE;
        }
        return ONE.divide(this.pow(-n));
    }

    public Unit<Q> prefix(Prefix prefix) {
        return this.transform(MultiplyConverter.ofPrefix(prefix));
    }

    @Override
    public int compareTo(Unit<Q> that) {
        int symbolComparison = this.compareToWithPossibleNullValues(this.getSymbol(), that.getSymbol());
        if (symbolComparison == 0) {
            return this.compareToWithPossibleNullValues(this.name, that.getName());
        }
        return symbolComparison;
    }

    private int compareToWithPossibleNullValues(String a, String b) {
        if (a == null) {
            return b == null ? 0 : -1;
        }
        return b == null ? 1 : a.compareTo(b);
    }

    public boolean isEquivalentTo(Unit<Q> that) {
        return this.getConverterTo(that).isIdentity();
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    protected static final class Equalizer {
        protected Equalizer() {
        }

        public static boolean areEqual(Unit u1, Unit u2) {
            return u1 != null && u1.equals(u2);
        }
    }
}

