/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.quantity;

import java.util.function.BinaryOperator;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import tech.units.indriya.AbstractQuantity;
import tech.units.indriya.ComparableQuantity;
import tech.units.indriya.function.AddConverter;
import tech.units.indriya.internal.function.calc.Calculator;
import tech.units.indriya.quantity.Quantities;

public class NumberQuantity<Q extends Quantity<Q>>
extends AbstractQuantity<Q> {
    private static final long serialVersionUID = -6494337491031528402L;
    private final Number value;

    protected NumberQuantity(Number number, Unit<Q> unit, Quantity.Scale sc) {
        super(unit, sc);
        this.value = number;
    }

    protected NumberQuantity(Number number, Unit<Q> unit) {
        this(number, unit, Quantity.Scale.ABSOLUTE);
    }

    @Override
    public ComparableQuantity<Q> add(Quantity<Q> that) {
        return this.addition(that, (thisValueInSystemUnit, thatValueInSystemUnit) -> Calculator.of(thisValueInSystemUnit).add((Number)thatValueInSystemUnit).peek());
    }

    @Override
    public ComparableQuantity<Q> subtract(Quantity<Q> that) {
        return this.addition(that, (thisValueInSystemUnit, thatValueInSystemUnit) -> Calculator.of(thisValueInSystemUnit).subtract((Number)thatValueInSystemUnit).peek());
    }

    @Override
    public ComparableQuantity<?> divide(Quantity<?> that) {
        Number resultValueInThisUnit = Calculator.of(this.getValue()).divide(that.getValue()).peek();
        return Quantities.getQuantity(resultValueInThisUnit, this.getUnit().divide(that.getUnit()));
    }

    @Override
    public ComparableQuantity<Q> divide(Number divisor) {
        Number resultValueInThisUnit = Calculator.of(this.getValue()).divide(divisor).peek();
        return Quantities.getQuantity(resultValueInThisUnit, this.getUnit());
    }

    @Override
    public ComparableQuantity<?> multiply(Quantity<?> that) {
        Number resultValueInThisUnit = Calculator.of(this.getValue()).multiply(that.getValue()).peek();
        return Quantities.getQuantity(resultValueInThisUnit, this.getUnit().multiply(that.getUnit()));
    }

    @Override
    public ComparableQuantity<Q> multiply(Number multiplier) {
        Number resultValueInThisUnit = Calculator.of(this.getValue()).multiply(multiplier).peek();
        return Quantities.getQuantity(resultValueInThisUnit, this.getUnit());
    }

    @Override
    public ComparableQuantity<?> inverse() {
        Number resultValueInThisUnit = Calculator.of(this.getValue()).reciprocal().peek();
        return Quantities.getQuantity(resultValueInThisUnit, this.getUnit().inverse());
    }

    public Quantity<Q> negate() {
        Number resultValueInThisUnit = Calculator.of(this.getValue()).negate().peek();
        return Quantities.getQuantity(resultValueInThisUnit, this.getUnit());
    }

    @Override
    public Number getValue() {
        return this.value;
    }

    private ComparableQuantity<Q> addition(Quantity<Q> that, BinaryOperator<Number> operator) {
        Number resultValueInThisUnit;
        Unit systemUnit = this.getUnit().getSystemUnit();
        UnitConverter c1 = this.getUnit().getConverterTo(systemUnit);
        UnitConverter c2 = that.getUnit().getConverterTo(systemUnit);
        boolean shouldConvertThis = this.shouldConvertQuantityForAddition(c1, this.getScale());
        boolean shouldConvertThat = this.shouldConvertQuantityForAddition(c2, that.getScale());
        Number thisValueInSystemUnit = shouldConvertThis ? (Number)c1.convert(this.getValue()) : (Number)this.getValue();
        Number thatValueInSystemUnit = shouldConvertThat ? (Number)c2.convert(that.getValue()) : (Number)this.getValue();
        Number resultValueInSystemUnit = (Number)operator.apply(thisValueInSystemUnit, thatValueInSystemUnit);
        Number number = resultValueInThisUnit = shouldConvertThis || shouldConvertThat ? (Number)c1.inverse().convert(resultValueInSystemUnit) : (Number)resultValueInSystemUnit;
        if (this.getScale().equals((Object)that.getScale())) {
            return Quantities.getQuantity(resultValueInThisUnit, this.getUnit(), this.getScale());
        }
        return Quantities.getQuantity(resultValueInThisUnit, this.getUnit());
    }

    private boolean shouldConvertQuantityForAddition(UnitConverter c1, Quantity.Scale scale) {
        return !(c1 instanceof AddConverter) || !scale.equals((Object)Quantity.Scale.RELATIVE);
    }
}

