/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.test.mock;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.knowm.xchange.exceptions.NotAvailableFromExchangeException;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import tech.cassandre.trading.bot.batch.TickerFlux;
import tech.cassandre.trading.bot.dto.market.TickerDTO;
import tech.cassandre.trading.bot.dto.util.CurrencyDTO;
import tech.cassandre.trading.bot.dto.util.CurrencyPairDTO;
import tech.cassandre.trading.bot.service.MarketService;

@TestConfiguration
public class TickerFluxMock {
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    public static final int MILLISECONDS = 1000;
    private static final String TICKERS_FILE_PREFIX = "tickers-";
    private static final String TICKERS_FILE_SUFFIX = ".*sv";
    private final HashMap<CurrencyPairDTO, Boolean> fluxTerminated = new LinkedHashMap<CurrencyPairDTO, Boolean>();

    @Bean
    @Primary
    public TickerFlux tickerFlux() {
        return new TickerFlux(this.marketService());
    }

    @Bean
    @Primary
    public MarketService marketService() {
        MarketService marketService = (MarketService)Mockito.mock(MarketService.class);
        BDDMockito.given((Object)marketService.getTickers((Set)ArgumentMatchers.any())).willThrow(new Throwable[]{new NotAvailableFromExchangeException("Not available in this mode")});
        this.getFilesToLoad().stream().filter(resource -> resource.getFilename() != null).forEach(resource -> {
            CurrencyPairDTO cp = this.getCurrencyPairFromFileName((Resource)resource);
            this.logger.info("Adding tests data from " + resource.getFilename().substring(resource.getFilename().indexOf(TICKERS_FILE_PREFIX)));
            this.fluxTerminated.put(cp, false);
            Mockito.when((Object)marketService.getTicker(cp)).thenAnswer(new Answer((Resource)resource, cp){
                private final Iterator tickers;
                final /* synthetic */ Resource val$resource;
                final /* synthetic */ CurrencyPairDTO val$cp;
                {
                    this.val$resource = resource;
                    this.val$cp = currencyPairDTO;
                    this.tickers = TickerFluxMock.this.getTickersFromFile(this.val$resource).iterator();
                }

                public Object answer(InvocationOnMock invocationOnMock) {
                    try {
                        TimeUnit.SECONDS.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    if (this.tickers.hasNext()) {
                        return Optional.of((TickerDTO)this.tickers.next());
                    }
                    TickerFluxMock.this.fluxTerminated.put(this.val$cp, true);
                    return Optional.empty();
                }
            });
        });
        return marketService;
    }

    public List<Resource> getFilesToLoad() {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            Resource[] resources = resolver.getResources("classpath*:tickers-*.*sv");
            return Arrays.asList(resources);
        }
        catch (IOException e) {
            this.logger.error("TickerFluxMock encountered an error : " + e.getMessage());
            return Collections.emptyList();
        }
    }

    public CurrencyPairDTO getCurrencyPairFromFileName(Resource file) {
        if (file.getFilename() != null) {
            int currencyPairIndexStart = file.getFilename().indexOf(TICKERS_FILE_PREFIX) + TICKERS_FILE_PREFIX.length();
            int currencyPairIndexStop = file.getFilename().indexOf("sv") - 2;
            String currencyPairAsString = file.getFilename().substring(currencyPairIndexStart, currencyPairIndexStop);
            String[] currencyPairAsSplit = currencyPairAsString.split("-");
            return new CurrencyPairDTO(new CurrencyDTO(currencyPairAsSplit[0].toUpperCase()), new CurrencyDTO(currencyPairAsSplit[1].toUpperCase()));
        }
        return null;
    }

    private List<TickerDTO> getTickersFromFile(Resource file) {
        CurrencyPairDTO currencyPair = this.getCurrencyPairFromFileName(file);
        LinkedList<TickerDTO> tickers = new LinkedList<TickerDTO>();
        try (Scanner scanner = new Scanner(file.getFile());){
            while (scanner.hasNextLine()) {
                try (Scanner rowScanner = new Scanner(scanner.nextLine());){
                    if (file.getFilename() != null && file.getFilename().endsWith("tsv")) {
                        rowScanner.useDelimiter("\t");
                    } else {
                        rowScanner.useDelimiter(",");
                    }
                    while (rowScanner.hasNext()) {
                        String time = rowScanner.next().replaceAll("\"", "");
                        String open = rowScanner.next().replaceAll("\"", "");
                        String close = rowScanner.next().replaceAll("\"", "");
                        String high = rowScanner.next().replaceAll("\"", "");
                        String low = rowScanner.next().replaceAll("\"", "");
                        String volume = rowScanner.next().replaceAll("\"", "");
                        String turnover = null;
                        turnover = rowScanner.hasNext() ? rowScanner.next().replaceAll("\"", "") : "0";
                        TickerDTO t = TickerDTO.builder().currencyPair(currencyPair).timestamp(ZonedDateTime.ofInstant(new Date(Long.parseLong(time) * 1000L).toInstant(), ZoneId.systemDefault())).open(new BigDecimal(open)).last(new BigDecimal(close)).high(new BigDecimal(high)).low(new BigDecimal(low)).volume(new BigDecimal(volume)).quoteVolume(new BigDecimal(turnover)).build();
                        tickers.add(t);
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            this.logger.error("{} not found !", (Object)file.getFilename());
        }
        catch (IOException e) {
            this.logger.error("IOException : " + e);
        }
        return tickers;
    }

    public boolean isFluxDone(CurrencyPairDTO currencyPair) {
        return this.fluxTerminated.getOrDefault(currencyPair, false);
    }

    public boolean isFluxDone() {
        return !this.fluxTerminated.containsValue(false);
    }
}

