/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.util.validator;

import java.time.Duration;
import java.time.format.DateTimeParseException;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.math.NumberUtils;
import tech.cassandre.trading.bot.util.validator.Rate;

public class RateValidator
implements ConstraintValidator<Rate, String> {
    public final boolean isValid(String value, ConstraintValidatorContext constraintValidatorContext) {
        if (value == null || value.length() == 0) {
            return false;
        }
        if (NumberUtils.isCreatable((String)value)) {
            return true;
        }
        try {
            Duration.parse(value);
            return true;
        }
        catch (DateTimeParseException e) {
            return false;
        }
    }
}

