/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.util.parameters;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;
import tech.cassandre.trading.bot.util.validator.Rate;

@Validated
@ConfigurationProperties(prefix="cassandre.trading.bot.exchange")
public class ExchangeParameters {
    @NotEmpty(message="Exchange name required, for example : coinbase, kraken, kucoin...")
    private @NotEmpty(message="Exchange name required, for example : coinbase, kraken, kucoin...") String name;
    @NotEmpty(message="API username required")
    private @NotEmpty(message="API username required") String username;
    @NotEmpty(message="API passphrase required")
    private @NotEmpty(message="API passphrase required") String passphrase;
    @NotEmpty(message="API key required")
    private @NotEmpty(message="API key required") String key;
    @NotEmpty(message="API secret required")
    private @NotEmpty(message="API secret required") String secret;
    private String proxyHost;
    private Integer proxyPort;
    private String sslUri;
    private String plainTextUri;
    private String host;
    private String port;
    @Valid
    private Modes modes = new Modes();
    @Valid
    private Rates rates = new Rates();

    public String getName() {
        return this.name;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public String getKey() {
        return this.key;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public String getSslUri() {
        return this.sslUri;
    }

    public String getPlainTextUri() {
        return this.plainTextUri;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public Modes getModes() {
        return this.modes;
    }

    public Rates getRates() {
        return this.rates;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setSslUri(String sslUri) {
        this.sslUri = sslUri;
    }

    public void setPlainTextUri(String plainTextUri) {
        this.plainTextUri = plainTextUri;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setModes(Modes modes) {
        this.modes = modes;
    }

    public void setRates(Rates rates) {
        this.rates = rates;
    }

    public String toString() {
        return "ExchangeParameters(name=" + this.getName() + ", username=" + this.getUsername() + ", passphrase=" + this.getPassphrase() + ", key=" + this.getKey() + ", secret=" + this.getSecret() + ", proxyHost=" + this.getProxyHost() + ", proxyPort=" + this.getProxyPort() + ", sslUri=" + this.getSslUri() + ", plainTextUri=" + this.getPlainTextUri() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", modes=" + this.getModes() + ", rates=" + this.getRates() + ")";
    }

    @Validated
    @ConfigurationProperties(prefix="cassandre.trading.bot.exchange.rates")
    public static class Rates {
        @NotNull(message="Delay between calls to account API is mandatory")
        @Rate(message="Invalid account rate - Enter a long value (ex: 123) or a standard ISO 8601 duration (ex: PT10H)")
        private @NotNull(message="Delay between calls to account API is mandatory") String account;
        @NotNull(message="Delay between calls to ticker API is mandatory")
        @Rate(message="Invalid ticker rate - Enter a long value (ex: 123) or a standard ISO 8601 duration (ex: PT10H)")
        private @NotNull(message="Delay between calls to ticker API is mandatory") String ticker;
        @NotNull(message="Delay between calls to trade API is mandatory")
        @Rate(message="Invalid trade rate - Enter a long value (ex: 123) or a standard ISO 8601 duration (ex: PT10H)")
        private @NotNull(message="Delay between calls to trade API is mandatory") String trade;

        public String getAccount() {
            return this.account;
        }

        public String getTicker() {
            return this.ticker;
        }

        public String getTrade() {
            return this.trade;
        }

        public void setAccount(String account) {
            this.account = account;
        }

        public void setTicker(String ticker) {
            this.ticker = ticker;
        }

        public void setTrade(String trade) {
            this.trade = trade;
        }

        public String toString() {
            return "ExchangeParameters.Rates(account=" + this.getAccount() + ", ticker=" + this.getTicker() + ", trade=" + this.getTrade() + ")";
        }
    }

    @Validated
    @ConfigurationProperties(prefix="cassandre.trading.bot.exchange.modes")
    public static class Modes {
        @NotNull(message="Sandbox parameter required, set it to true to use the sandbox")
        private @NotNull(message="Sandbox parameter required, set it to true to use the sandbox") Boolean sandbox;
        @NotNull(message="Dry parameter required, set it to true to use the dry mode")
        private @NotNull(message="Dry parameter required, set it to true to use the dry mode") Boolean dry;

        public Boolean getSandbox() {
            return this.sandbox;
        }

        public Boolean getDry() {
            return this.dry;
        }

        public void setSandbox(Boolean sandbox) {
            this.sandbox = sandbox;
        }

        public void setDry(Boolean dry) {
            this.dry = dry;
        }

        public String toString() {
            return "ExchangeParameters.Modes(sandbox=" + this.getSandbox() + ", dry=" + this.getDry() + ")";
        }
    }
}

