/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.util.parameters;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(prefix="cassandre.trading.bot.database")
public class DatabaseParameters {
    @Valid
    private Datasource datasource = new Datasource();

    public Datasource getDatasource() {
        return this.datasource;
    }

    public void setDatasource(Datasource datasource) {
        this.datasource = datasource;
    }

    public String toString() {
        return "DatabaseParameters(datasource=" + this.getDatasource() + ")";
    }

    @Validated
    @ConfigurationProperties(prefix="cassandre.trading.bot.database.datasource")
    public static class Datasource {
        public static final String PARAMETER_DATABASE_DATASOURCE_DRIVER_CLASS_NAME = "cassandre.trading.bot.database.datasource.driver-class-name";
        public static final String PARAMETER_DATABASE_DATASOURCE_URL = "cassandre.trading.bot.database.datasource.url";
        public static final String PARAMETER_DATABASE_DATASOURCE_USERNAME = "cassandre.trading.bot.database.datasource.username";
        public static final String PARAMETER_DATABASE_DATASOURCE_PASSWORD = "cassandre.trading.bot.database.datasource.password";
        @NotNull(message="Database driver class name must be set")
        private @NotNull(message="Database driver class name must be set") String driverClassName;
        @NotNull(message="Database url must be set")
        private @NotNull(message="Database url must be set") String url;
        @NotNull(message="Database username must be set")
        private @NotNull(message="Database username must be set") String username;
        private String password;

        public String getDriverClassName() {
            return this.driverClassName;
        }

        public String getUrl() {
            return this.url;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setDriverClassName(String driverClassName) {
            this.driverClassName = driverClassName;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String toString() {
            return "DatabaseParameters.Datasource(driverClassName=" + this.getDriverClassName() + ", url=" + this.getUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ")";
        }
    }
}

