/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.util.mapper;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.knowm.xchange.dto.trade.UserTrade;
import org.mapstruct.factory.Mappers;
import tech.cassandre.trading.bot.domain.Order;
import tech.cassandre.trading.bot.domain.Trade;
import tech.cassandre.trading.bot.dto.trade.TradeDTO;
import tech.cassandre.trading.bot.dto.util.CurrencyAmountDTO;
import tech.cassandre.trading.bot.util.jpa.CurrencyAmount;
import tech.cassandre.trading.bot.util.mapper.CurrencyMapper;
import tech.cassandre.trading.bot.util.mapper.TradeMapper;
import tech.cassandre.trading.bot.util.mapper.UtilMapper;

public class TradeMapperImpl
implements TradeMapper {
    private final UtilMapper utilMapper = (UtilMapper)Mappers.getMapper(UtilMapper.class);
    private final CurrencyMapper currencyMapper = (CurrencyMapper)Mappers.getMapper(CurrencyMapper.class);

    @Override
    public TradeDTO mapToTradeDTO(UserTrade source) {
        if (source == null) {
            return null;
        }
        TradeDTO.TradeDTOBuilder tradeDTO = TradeDTO.builder();
        tradeDTO.tradeId(source.getId());
        tradeDTO.amount(this.mapUserTradeToTradeDTOAmount(source));
        tradeDTO.price(this.mapUserTradeToTradeDTOPrice(source));
        tradeDTO.fee(this.mapUserTradeToTradeDTOFee(source));
        tradeDTO.userReference(source.getOrderUserReference());
        tradeDTO.currencyPair(this.currencyMapper.mapToCurrencyPairDTO(source.getInstrument()));
        tradeDTO.type(this.utilMapper.mapToOrderTypeDTO(source.getType()));
        tradeDTO.orderId(source.getOrderId());
        if (source.getTimestamp() != null) {
            tradeDTO.timestamp(ZonedDateTime.ofInstant(source.getTimestamp().toInstant(), ZoneId.systemDefault()));
        }
        return tradeDTO.build();
    }

    @Override
    public Trade mapToTrade(TradeDTO source) {
        if (source == null) {
            return null;
        }
        Trade trade = new Trade();
        trade.setTradeId(source.getTradeId());
        trade.setType(source.getType());
        trade.setOrderId(source.getOrderId());
        trade.setCurrencyPair(this.currencyMapper.mapToCurrencyPairString(source.getCurrencyPair()));
        trade.setAmount(this.currencyAmountDTOToCurrencyAmount(source.getAmount()));
        trade.setPrice(this.currencyAmountDTOToCurrencyAmount(source.getPrice()));
        trade.setFee(this.currencyAmountDTOToCurrencyAmount(source.getFee()));
        trade.setUserReference(source.getUserReference());
        trade.setTimestamp(source.getTimestamp());
        return trade;
    }

    @Override
    public void updateTrade(TradeDTO source, Trade target) {
        if (source == null) {
            return;
        }
        if (source.getId() != null) {
            target.setId(source.getId());
        }
        if (source.getTradeId() != null) {
            target.setTradeId(source.getTradeId());
        }
        if (source.getType() != null) {
            target.setType(source.getType());
        }
        if (source.getOrderId() != null) {
            target.setOrderId(source.getOrderId());
        }
        if (source.getCurrencyPair() != null) {
            target.setCurrencyPair(this.currencyMapper.mapToCurrencyPairString(source.getCurrencyPair()));
        }
        if (source.getAmount() != null) {
            if (target.getAmount() == null) {
                target.setAmount(new CurrencyAmount());
            }
            this.currencyAmountDTOToCurrencyAmount1(source.getAmount(), target.getAmount());
        }
        if (source.getPrice() != null) {
            if (target.getPrice() == null) {
                target.setPrice(new CurrencyAmount());
            }
            this.currencyAmountDTOToCurrencyAmount1(source.getPrice(), target.getPrice());
        }
        if (source.getFee() != null) {
            if (target.getFee() == null) {
                target.setFee(new CurrencyAmount());
            }
            this.currencyAmountDTOToCurrencyAmount1(source.getFee(), target.getFee());
        }
        if (source.getUserReference() != null) {
            target.setUserReference(source.getUserReference());
        }
        if (source.getTimestamp() != null) {
            target.setTimestamp(source.getTimestamp());
        }
    }

    @Override
    public TradeDTO mapToTradeDTO(Trade source) {
        if (source == null) {
            return null;
        }
        TradeDTO.TradeDTOBuilder tradeDTO = TradeDTO.builder();
        tradeDTO.id(source.getId());
        tradeDTO.tradeId(source.getTradeId());
        tradeDTO.type(source.getType());
        tradeDTO.orderId(source.getOrderId());
        tradeDTO.order(this.orderToOrder(source.getOrder()));
        tradeDTO.currencyPair(this.currencyMapper.mapToCurrencyPairDTO(source.getCurrencyPair()));
        tradeDTO.amount(this.currencyMapper.mapToCurrencyAmountDTO(source.getAmount()));
        tradeDTO.price(this.currencyMapper.mapToCurrencyAmountDTO(source.getPrice()));
        tradeDTO.fee(this.currencyMapper.mapToCurrencyAmountDTO(source.getFee()));
        tradeDTO.userReference(source.getUserReference());
        tradeDTO.timestamp(source.getTimestamp());
        return tradeDTO.build();
    }

    protected CurrencyAmount currencyAmountDTOToCurrencyAmount(CurrencyAmountDTO currencyAmountDTO) {
        if (currencyAmountDTO == null) {
            return null;
        }
        CurrencyAmount currencyAmount = new CurrencyAmount();
        currencyAmount.setValue(currencyAmountDTO.getValue());
        currencyAmount.setCurrency(this.currencyMapper.mapToCurrencyString(currencyAmountDTO.getCurrency()));
        return currencyAmount;
    }

    protected void currencyAmountDTOToCurrencyAmount1(CurrencyAmountDTO currencyAmountDTO, CurrencyAmount mappingTarget) {
        if (currencyAmountDTO == null) {
            return;
        }
        if (currencyAmountDTO.getValue() != null) {
            mappingTarget.setValue(currencyAmountDTO.getValue());
        }
        if (currencyAmountDTO.getCurrency() != null) {
            mappingTarget.setCurrency(this.currencyMapper.mapToCurrencyString(currencyAmountDTO.getCurrency()));
        }
    }

    protected Order orderToOrder(Order order) {
        if (order == null) {
            return null;
        }
        Order order1 = new Order();
        order1.setCreatedOn(order.getCreatedOn());
        order1.setUpdatedOn(order.getUpdatedOn());
        order1.setId(order.getId());
        order1.setOrderId(order.getOrderId());
        order1.setType(order.getType());
        order1.setStrategy(order.getStrategy());
        order1.setCurrencyPair(order.getCurrencyPair());
        order1.setAmount(order.getAmount());
        order1.setAveragePrice(order.getAveragePrice());
        order1.setLimitPrice(order.getLimitPrice());
        order1.setLeverage(order.getLeverage());
        order1.setStatus(order.getStatus());
        order1.setCumulativeAmount(order.getCumulativeAmount());
        order1.setUserReference(order.getUserReference());
        order1.setTimestamp(order.getTimestamp());
        return order1;
    }
}

