/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.util.mapper;

import org.knowm.xchange.dto.trade.UserTrade;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.mapstruct.Named;
import org.mapstruct.NullValuePropertyMappingStrategy;
import tech.cassandre.trading.bot.domain.Trade;
import tech.cassandre.trading.bot.dto.trade.TradeDTO;
import tech.cassandre.trading.bot.dto.util.CurrencyAmountDTO;
import tech.cassandre.trading.bot.dto.util.CurrencyDTO;
import tech.cassandre.trading.bot.dto.util.CurrencyPairDTO;
import tech.cassandre.trading.bot.util.mapper.CurrencyMapper;
import tech.cassandre.trading.bot.util.mapper.UtilMapper;

@Mapper(uses={UtilMapper.class, CurrencyMapper.class}, nullValuePropertyMappingStrategy=NullValuePropertyMappingStrategy.IGNORE)
public interface TradeMapper {
    @Mappings(value={@Mapping(source="id", target="tradeId"), @Mapping(target="id", ignore=true), @Mapping(source="source", target="amount", qualifiedByName={"mapUserTradeToTradeDTOAmount"}), @Mapping(source="source", target="price", qualifiedByName={"mapUserTradeToTradeDTOPrice"}), @Mapping(source="source", target="fee", qualifiedByName={"mapUserTradeToTradeDTOFee"}), @Mapping(source="orderUserReference", target="userReference"), @Mapping(source="instrument", target="currencyPair")})
    public TradeDTO mapToTradeDTO(UserTrade var1);

    @Named(value="mapUserTradeToTradeDTOAmount")
    @Mappings(value={@Mapping(target="createdOn", ignore=true), @Mapping(target="updatedOn", ignore=true)})
    default public CurrencyAmountDTO mapUserTradeToTradeDTOAmount(UserTrade source) {
        CurrencyPairDTO cp = new CurrencyPairDTO(source.getInstrument());
        return CurrencyAmountDTO.builder().value(source.getOriginalAmount()).currency(cp.getBaseCurrency()).build();
    }

    @Named(value="mapUserTradeToTradeDTOPrice")
    default public CurrencyAmountDTO mapUserTradeToTradeDTOPrice(UserTrade source) {
        CurrencyPairDTO cp = new CurrencyPairDTO(source.getInstrument());
        return CurrencyAmountDTO.builder().value(source.getPrice()).currency(cp.getQuoteCurrency()).build();
    }

    @Named(value="mapUserTradeToTradeDTOFee")
    default public CurrencyAmountDTO mapUserTradeToTradeDTOFee(UserTrade source) {
        if (source.getFeeAmount() != null && source.getFeeCurrency() != null) {
            return CurrencyAmountDTO.builder().value(source.getFeeAmount()).currency(new CurrencyDTO(source.getFeeCurrency().toString())).build();
        }
        return null;
    }

    @Mappings(value={@Mapping(target="id", ignore=true), @Mapping(target="createdOn", ignore=true), @Mapping(target="updatedOn", ignore=true), @Mapping(target="order", ignore=true)})
    public Trade mapToTrade(TradeDTO var1);

    @Mappings(value={@Mapping(target="createdOn", ignore=true), @Mapping(target="updatedOn", ignore=true), @Mapping(target="order", ignore=true)})
    public void updateTrade(TradeDTO var1, @MappingTarget Trade var2);

    @Mapping(target="order.trades", ignore=true)
    public TradeDTO mapToTradeDTO(Trade var1);
}

