/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.util.mapper;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.mapstruct.factory.Mappers;
import tech.cassandre.trading.bot.dto.market.TickerDTO;
import tech.cassandre.trading.bot.util.mapper.CurrencyMapper;
import tech.cassandre.trading.bot.util.mapper.TickerMapper;

public class TickerMapperImpl
implements TickerMapper {
    private final CurrencyMapper currencyMapper = (CurrencyMapper)Mappers.getMapper(CurrencyMapper.class);

    @Override
    public TickerDTO mapToTickerDTO(Ticker source) {
        if (source == null) {
            return null;
        }
        TickerDTO.TickerDTOBuilder tickerDTO = TickerDTO.builder();
        tickerDTO.currencyPair(this.currencyMapper.mapToCurrencyPairDTO(source.getInstrument()));
        tickerDTO.open(source.getOpen());
        tickerDTO.last(source.getLast());
        tickerDTO.bid(source.getBid());
        tickerDTO.ask(source.getAsk());
        tickerDTO.high(source.getHigh());
        tickerDTO.low(source.getLow());
        tickerDTO.vwap(source.getVwap());
        tickerDTO.volume(source.getVolume());
        tickerDTO.quoteVolume(source.getQuoteVolume());
        tickerDTO.bidSize(source.getBidSize());
        tickerDTO.askSize(source.getAskSize());
        if (source.getTimestamp() != null) {
            tickerDTO.timestamp(ZonedDateTime.ofInstant(source.getTimestamp().toInstant(), ZoneId.systemDefault()));
        }
        return tickerDTO.build();
    }
}

