/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.util.mapper;

import org.mapstruct.factory.Mappers;
import tech.cassandre.trading.bot.domain.Order;
import tech.cassandre.trading.bot.domain.Position;
import tech.cassandre.trading.bot.dto.position.PositionDTO;
import tech.cassandre.trading.bot.dto.position.PositionRulesDTO;
import tech.cassandre.trading.bot.dto.util.CurrencyAmountDTO;
import tech.cassandre.trading.bot.util.jpa.CurrencyAmount;
import tech.cassandre.trading.bot.util.mapper.CurrencyMapper;
import tech.cassandre.trading.bot.util.mapper.OrderMapper;
import tech.cassandre.trading.bot.util.mapper.PositionMapper;
import tech.cassandre.trading.bot.util.mapper.StrategyMapper;

public class PositionMapperImpl
implements PositionMapper {
    private final CurrencyMapper currencyMapper = (CurrencyMapper)Mappers.getMapper(CurrencyMapper.class);
    private final OrderMapper orderMapper = (OrderMapper)Mappers.getMapper(OrderMapper.class);
    private final StrategyMapper strategyMapper = (StrategyMapper)Mappers.getMapper(StrategyMapper.class);

    @Override
    public Position mapToPosition(PositionDTO source) {
        if (source == null) {
            return null;
        }
        Position position = new Position();
        position.setStopGainPercentageRule(this.sourceRulesStopGainPercentage(source));
        position.setStopLossPercentageRule(this.sourceRulesStopLossPercentage(source));
        position.setId(source.getId());
        position.setPositionId(source.getPositionId());
        position.setType(source.getType());
        position.setStrategy(this.strategyMapper.mapToStrategy(source.getStrategy()));
        position.setCurrencyPair(this.currencyMapper.mapToCurrencyPairString(source.getCurrencyPair()));
        position.setAmount(this.currencyAmountDTOToCurrencyAmount(source.getAmount()));
        position.setStatus(source.getStatus());
        position.setForceClosing(source.isForceClosing());
        position.setOpeningOrderId(source.getOpeningOrderId());
        position.setOpeningOrder(this.orderMapper.mapToOrder(source.getOpeningOrder()));
        position.setClosingOrderId(source.getClosingOrderId());
        position.setClosingOrder(this.orderMapper.mapToOrder(source.getClosingOrder()));
        position.setLowestGainPrice(this.currencyAmountDTOToCurrencyAmount(source.getLowestGainPrice()));
        position.setHighestGainPrice(this.currencyAmountDTOToCurrencyAmount(source.getHighestGainPrice()));
        position.setLatestGainPrice(this.currencyAmountDTOToCurrencyAmount(source.getLatestGainPrice()));
        return position;
    }

    @Override
    public void updatePosition(PositionDTO source, Position target) {
        if (source == null) {
            return;
        }
        if (source.getType() != null) {
            target.setType(source.getType());
        }
        if (source.getCurrencyPair() != null) {
            target.setCurrencyPair(this.currencyMapper.mapToCurrencyPairString(source.getCurrencyPair()));
        }
        if (source.getAmount() != null) {
            if (target.getAmount() == null) {
                target.setAmount(new CurrencyAmount());
            }
            this.currencyAmountDTOToCurrencyAmount1(source.getAmount(), target.getAmount());
        }
        if (source.getStatus() != null) {
            target.setStatus(source.getStatus());
        }
        target.setForceClosing(source.isForceClosing());
        if (source.getOpeningOrderId() != null) {
            target.setOpeningOrderId(source.getOpeningOrderId());
        }
        if (source.getOpeningOrder() != null) {
            if (target.getOpeningOrder() == null) {
                target.setOpeningOrder(new Order());
            }
            this.orderMapper.updateOrder(source.getOpeningOrder(), target.getOpeningOrder());
        }
        if (source.getClosingOrderId() != null) {
            target.setClosingOrderId(source.getClosingOrderId());
        }
        if (source.getClosingOrder() != null) {
            if (target.getClosingOrder() == null) {
                target.setClosingOrder(new Order());
            }
            this.orderMapper.updateOrder(source.getClosingOrder(), target.getClosingOrder());
        }
        if (source.getLowestGainPrice() != null) {
            if (target.getLowestGainPrice() == null) {
                target.setLowestGainPrice(new CurrencyAmount());
            }
            this.currencyAmountDTOToCurrencyAmount1(source.getLowestGainPrice(), target.getLowestGainPrice());
        }
        if (source.getHighestGainPrice() != null) {
            if (target.getHighestGainPrice() == null) {
                target.setHighestGainPrice(new CurrencyAmount());
            }
            this.currencyAmountDTOToCurrencyAmount1(source.getHighestGainPrice(), target.getHighestGainPrice());
        }
        if (source.getLatestGainPrice() != null) {
            if (target.getLatestGainPrice() == null) {
                target.setLatestGainPrice(new CurrencyAmount());
            }
            this.currencyAmountDTOToCurrencyAmount1(source.getLatestGainPrice(), target.getLatestGainPrice());
        }
    }

    @Override
    public PositionDTO mapToPositionDTO(Position source) {
        if (source == null) {
            return null;
        }
        PositionDTO.PositionDTOBuilder positionDTO = PositionDTO.builder();
        positionDTO.rules(this.mapToPositionRulesDTO(source));
        if (source.getId() != null) {
            positionDTO.id(source.getId());
        }
        positionDTO.positionId(source.getPositionId());
        positionDTO.type(source.getType());
        positionDTO.strategy(this.strategyMapper.mapToStrategyDTO(source.getStrategy()));
        positionDTO.currencyPair(this.currencyMapper.mapToCurrencyPairDTO(source.getCurrencyPair()));
        positionDTO.amount(this.currencyMapper.mapToCurrencyAmountDTO(source.getAmount()));
        positionDTO.status(source.getStatus());
        positionDTO.forceClosing(source.isForceClosing());
        positionDTO.openingOrderId(source.getOpeningOrderId());
        positionDTO.openingOrder(this.orderMapper.mapToOrderDTO(source.getOpeningOrder()));
        positionDTO.closingOrderId(source.getClosingOrderId());
        positionDTO.closingOrder(this.orderMapper.mapToOrderDTO(source.getClosingOrder()));
        positionDTO.lowestGainPrice(this.currencyMapper.mapToCurrencyAmountDTO(source.getLowestGainPrice()));
        positionDTO.highestGainPrice(this.currencyMapper.mapToCurrencyAmountDTO(source.getHighestGainPrice()));
        positionDTO.latestGainPrice(this.currencyMapper.mapToCurrencyAmountDTO(source.getLatestGainPrice()));
        return positionDTO.build();
    }

    private Float sourceRulesStopGainPercentage(PositionDTO positionDTO) {
        if (positionDTO == null) {
            return null;
        }
        PositionRulesDTO rules = positionDTO.getRules();
        if (rules == null) {
            return null;
        }
        Float stopGainPercentage = rules.getStopGainPercentage();
        if (stopGainPercentage == null) {
            return null;
        }
        return stopGainPercentage;
    }

    private Float sourceRulesStopLossPercentage(PositionDTO positionDTO) {
        if (positionDTO == null) {
            return null;
        }
        PositionRulesDTO rules = positionDTO.getRules();
        if (rules == null) {
            return null;
        }
        Float stopLossPercentage = rules.getStopLossPercentage();
        if (stopLossPercentage == null) {
            return null;
        }
        return stopLossPercentage;
    }

    protected CurrencyAmount currencyAmountDTOToCurrencyAmount(CurrencyAmountDTO currencyAmountDTO) {
        if (currencyAmountDTO == null) {
            return null;
        }
        CurrencyAmount currencyAmount = new CurrencyAmount();
        currencyAmount.setValue(currencyAmountDTO.getValue());
        currencyAmount.setCurrency(this.currencyMapper.mapToCurrencyString(currencyAmountDTO.getCurrency()));
        return currencyAmount;
    }

    protected void currencyAmountDTOToCurrencyAmount1(CurrencyAmountDTO currencyAmountDTO, CurrencyAmount mappingTarget) {
        if (currencyAmountDTO == null) {
            return;
        }
        if (currencyAmountDTO.getValue() != null) {
            mappingTarget.setValue(currencyAmountDTO.getValue());
        }
        if (currencyAmountDTO.getCurrency() != null) {
            mappingTarget.setCurrency(this.currencyMapper.mapToCurrencyString(currencyAmountDTO.getCurrency()));
        }
    }
}

