/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.util.mapper;

import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.mapstruct.NullValuePropertyMappingStrategy;
import tech.cassandre.trading.bot.domain.Position;
import tech.cassandre.trading.bot.dto.position.PositionDTO;
import tech.cassandre.trading.bot.dto.position.PositionRulesDTO;
import tech.cassandre.trading.bot.util.mapper.CurrencyMapper;
import tech.cassandre.trading.bot.util.mapper.OrderMapper;
import tech.cassandre.trading.bot.util.mapper.StrategyMapper;
import tech.cassandre.trading.bot.util.mapper.UtilMapper;

@Mapper(uses={CurrencyMapper.class, OrderMapper.class, UtilMapper.class, StrategyMapper.class}, nullValuePropertyMappingStrategy=NullValuePropertyMappingStrategy.IGNORE)
public interface PositionMapper {
    @Mappings(value={@Mapping(source="rules.stopGainPercentage", target="stopGainPercentageRule"), @Mapping(source="rules.stopLossPercentage", target="stopLossPercentageRule"), @Mapping(target="createdOn", ignore=true), @Mapping(target="updatedOn", ignore=true)})
    public Position mapToPosition(PositionDTO var1);

    @Mappings(value={@Mapping(target="id", ignore=true), @Mapping(target="positionId", ignore=true), @Mapping(target="stopGainPercentageRule", ignore=true), @Mapping(target="stopLossPercentageRule", ignore=true), @Mapping(target="createdOn", ignore=true), @Mapping(target="updatedOn", ignore=true), @Mapping(target="strategy", ignore=true)})
    public void updatePosition(PositionDTO var1, @MappingTarget Position var2);

    @Mapping(source="source", target="rules")
    public PositionDTO mapToPositionDTO(Position var1);

    default public PositionRulesDTO mapToPositionRulesDTO(Position source) {
        boolean stopLossRuleSet;
        PositionRulesDTO rules = PositionRulesDTO.builder().build();
        boolean stopGainRuleSet = source.getStopGainPercentageRule() != null;
        boolean bl = stopLossRuleSet = source.getStopLossPercentageRule() != null;
        if (stopGainRuleSet && stopLossRuleSet) {
            rules = PositionRulesDTO.builder().stopGainPercentage(source.getStopGainPercentageRule()).stopLossPercentage(source.getStopLossPercentageRule()).build();
        }
        if (stopGainRuleSet && !stopLossRuleSet) {
            rules = PositionRulesDTO.builder().stopGainPercentage(source.getStopGainPercentageRule()).build();
        }
        if (!stopGainRuleSet && stopLossRuleSet) {
            rules = PositionRulesDTO.builder().stopLossPercentage(source.getStopLossPercentageRule()).build();
        }
        return rules;
    }
}

