/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.util.mapper;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.mapstruct.factory.Mappers;
import tech.cassandre.trading.bot.domain.Order;
import tech.cassandre.trading.bot.domain.Trade;
import tech.cassandre.trading.bot.dto.trade.OrderDTO;
import tech.cassandre.trading.bot.dto.trade.OrderStatusDTO;
import tech.cassandre.trading.bot.dto.trade.TradeDTO;
import tech.cassandre.trading.bot.dto.util.CurrencyAmountDTO;
import tech.cassandre.trading.bot.util.jpa.CurrencyAmount;
import tech.cassandre.trading.bot.util.mapper.CurrencyMapper;
import tech.cassandre.trading.bot.util.mapper.OrderMapper;
import tech.cassandre.trading.bot.util.mapper.StrategyMapper;
import tech.cassandre.trading.bot.util.mapper.TradeMapper;
import tech.cassandre.trading.bot.util.mapper.UtilMapper;

public class OrderMapperImpl
implements OrderMapper {
    private final UtilMapper utilMapper = (UtilMapper)Mappers.getMapper(UtilMapper.class);
    private final CurrencyMapper currencyMapper = (CurrencyMapper)Mappers.getMapper(CurrencyMapper.class);
    private final TradeMapper tradeMapper = (TradeMapper)Mappers.getMapper(TradeMapper.class);
    private final StrategyMapper strategyMapper = (StrategyMapper)Mappers.getMapper(StrategyMapper.class);

    @Override
    public OrderDTO mapToOrderDTO(LimitOrder source) {
        if (source == null) {
            return null;
        }
        OrderDTO.OrderDTOBuilder orderDTO = OrderDTO.builder();
        orderDTO.orderId(source.getId());
        orderDTO.amount(this.mapLimitOrderToOrderDTOAmount(source));
        orderDTO.cumulativeAmount(this.mapLimitOrderToOrderDTOCumulativeAmount(source));
        orderDTO.averagePrice(this.mapLimitOrderToOrderDTOAveragePrice(source));
        orderDTO.limitPrice(this.mapLimitOrderToOrderDTOLimitPrice(source));
        orderDTO.currencyPair(this.currencyMapper.mapToCurrencyPairDTO(source.getInstrument()));
        orderDTO.type(this.utilMapper.mapToOrderTypeDTO(source.getType()));
        orderDTO.leverage(source.getLeverage());
        orderDTO.status(this.orderStatusToOrderStatusDTO(source.getStatus()));
        orderDTO.userReference(source.getUserReference());
        if (source.getTimestamp() != null) {
            orderDTO.timestamp(ZonedDateTime.ofInstant(source.getTimestamp().toInstant(), ZoneId.systemDefault()));
        }
        return orderDTO.build();
    }

    @Override
    public Order mapToOrder(OrderDTO source) {
        if (source == null) {
            return null;
        }
        Order order = new Order();
        order.setId(source.getId());
        order.setOrderId(source.getOrderId());
        order.setType(source.getType());
        order.setStrategy(this.strategyMapper.mapToStrategy(source.getStrategy()));
        order.setCurrencyPair(this.currencyMapper.mapToCurrencyPairString(source.getCurrencyPair()));
        order.setAmount(this.currencyAmountDTOToCurrencyAmount(source.getAmount()));
        order.setAveragePrice(this.currencyAmountDTOToCurrencyAmount(source.getAveragePrice()));
        order.setLimitPrice(this.currencyAmountDTOToCurrencyAmount(source.getLimitPrice()));
        order.setLeverage(source.getLeverage());
        order.setStatus(source.getStatus());
        order.setCumulativeAmount(this.currencyAmountDTOToCurrencyAmount(source.getCumulativeAmount()));
        order.setUserReference(source.getUserReference());
        order.setTimestamp(source.getTimestamp());
        order.setTrades(this.tradeDTOSetToTradeSet(source.getTrades()));
        return order;
    }

    @Override
    public void updateOrder(OrderDTO source, Order target) {
        if (source == null) {
            return;
        }
        if (source.getId() != null) {
            target.setId(source.getId());
        }
        if (source.getOrderId() != null) {
            target.setOrderId(source.getOrderId());
        }
        if (source.getType() != null) {
            target.setType(source.getType());
        }
        if (source.getStrategy() != null) {
            target.setStrategy(this.strategyMapper.mapToStrategy(source.getStrategy()));
        }
        if (source.getCurrencyPair() != null) {
            target.setCurrencyPair(this.currencyMapper.mapToCurrencyPairString(source.getCurrencyPair()));
        }
        if (source.getAmount() != null) {
            if (target.getAmount() == null) {
                target.setAmount(new CurrencyAmount());
            }
            this.currencyAmountDTOToCurrencyAmount1(source.getAmount(), target.getAmount());
        }
        if (source.getAveragePrice() != null) {
            if (target.getAveragePrice() == null) {
                target.setAveragePrice(new CurrencyAmount());
            }
            this.currencyAmountDTOToCurrencyAmount1(source.getAveragePrice(), target.getAveragePrice());
        }
        if (source.getLimitPrice() != null) {
            if (target.getLimitPrice() == null) {
                target.setLimitPrice(new CurrencyAmount());
            }
            this.currencyAmountDTOToCurrencyAmount1(source.getLimitPrice(), target.getLimitPrice());
        }
        if (source.getLeverage() != null) {
            target.setLeverage(source.getLeverage());
        }
        if (source.getStatus() != null) {
            target.setStatus(source.getStatus());
        }
        if (source.getCumulativeAmount() != null) {
            if (target.getCumulativeAmount() == null) {
                target.setCumulativeAmount(new CurrencyAmount());
            }
            this.currencyAmountDTOToCurrencyAmount1(source.getCumulativeAmount(), target.getCumulativeAmount());
        }
        if (source.getUserReference() != null) {
            target.setUserReference(source.getUserReference());
        }
        if (source.getTimestamp() != null) {
            target.setTimestamp(source.getTimestamp());
        }
    }

    @Override
    public OrderDTO mapToOrderDTO(Order source) {
        if (source == null) {
            return null;
        }
        OrderDTO.OrderDTOBuilder orderDTO = OrderDTO.builder();
        orderDTO.trades(this.tradeSetToTradeDTOCollection(source.getTrades()));
        orderDTO.id(source.getId());
        orderDTO.orderId(source.getOrderId());
        orderDTO.type(source.getType());
        orderDTO.strategy(this.strategyMapper.mapToStrategyDTO(source.getStrategy()));
        orderDTO.currencyPair(this.currencyMapper.mapToCurrencyPairDTO(source.getCurrencyPair()));
        orderDTO.amount(this.currencyMapper.mapToCurrencyAmountDTO(source.getAmount()));
        orderDTO.averagePrice(this.currencyMapper.mapToCurrencyAmountDTO(source.getAveragePrice()));
        orderDTO.limitPrice(this.currencyMapper.mapToCurrencyAmountDTO(source.getLimitPrice()));
        orderDTO.leverage(source.getLeverage());
        orderDTO.status(source.getStatus());
        orderDTO.cumulativeAmount(this.currencyMapper.mapToCurrencyAmountDTO(source.getCumulativeAmount()));
        orderDTO.userReference(source.getUserReference());
        orderDTO.timestamp(source.getTimestamp());
        return orderDTO.build();
    }

    protected OrderStatusDTO orderStatusToOrderStatusDTO(Order.OrderStatus orderStatus) {
        OrderStatusDTO orderStatusDTO;
        if (orderStatus == null) {
            return null;
        }
        switch (orderStatus) {
            case PENDING_NEW: {
                orderStatusDTO = OrderStatusDTO.PENDING_NEW;
                break;
            }
            case NEW: {
                orderStatusDTO = OrderStatusDTO.NEW;
                break;
            }
            case PARTIALLY_FILLED: {
                orderStatusDTO = OrderStatusDTO.PARTIALLY_FILLED;
                break;
            }
            case FILLED: {
                orderStatusDTO = OrderStatusDTO.FILLED;
                break;
            }
            case PENDING_CANCEL: {
                orderStatusDTO = OrderStatusDTO.PENDING_CANCEL;
                break;
            }
            case PARTIALLY_CANCELED: {
                orderStatusDTO = OrderStatusDTO.PARTIALLY_CANCELED;
                break;
            }
            case CANCELED: {
                orderStatusDTO = OrderStatusDTO.CANCELED;
                break;
            }
            case PENDING_REPLACE: {
                orderStatusDTO = OrderStatusDTO.PENDING_REPLACE;
                break;
            }
            case REPLACED: {
                orderStatusDTO = OrderStatusDTO.REPLACED;
                break;
            }
            case STOPPED: {
                orderStatusDTO = OrderStatusDTO.STOPPED;
                break;
            }
            case REJECTED: {
                orderStatusDTO = OrderStatusDTO.REJECTED;
                break;
            }
            case EXPIRED: {
                orderStatusDTO = OrderStatusDTO.EXPIRED;
                break;
            }
            case OPEN: {
                orderStatusDTO = OrderStatusDTO.OPEN;
                break;
            }
            case CLOSED: {
                orderStatusDTO = OrderStatusDTO.CLOSED;
                break;
            }
            case UNKNOWN: {
                orderStatusDTO = OrderStatusDTO.UNKNOWN;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + orderStatus);
            }
        }
        return orderStatusDTO;
    }

    protected CurrencyAmount currencyAmountDTOToCurrencyAmount(CurrencyAmountDTO currencyAmountDTO) {
        if (currencyAmountDTO == null) {
            return null;
        }
        CurrencyAmount currencyAmount = new CurrencyAmount();
        currencyAmount.setValue(currencyAmountDTO.getValue());
        currencyAmount.setCurrency(this.currencyMapper.mapToCurrencyString(currencyAmountDTO.getCurrency()));
        return currencyAmount;
    }

    protected Set<Trade> tradeDTOSetToTradeSet(Set<TradeDTO> set) {
        if (set == null) {
            return null;
        }
        HashSet<Trade> set1 = new HashSet<Trade>(Math.max((int)((float)set.size() / 0.75f) + 1, 16));
        for (TradeDTO tradeDTO : set) {
            set1.add(this.tradeMapper.mapToTrade(tradeDTO));
        }
        return set1;
    }

    protected void currencyAmountDTOToCurrencyAmount1(CurrencyAmountDTO currencyAmountDTO, CurrencyAmount mappingTarget) {
        if (currencyAmountDTO == null) {
            return;
        }
        if (currencyAmountDTO.getValue() != null) {
            mappingTarget.setValue(currencyAmountDTO.getValue());
        }
        if (currencyAmountDTO.getCurrency() != null) {
            mappingTarget.setCurrency(this.currencyMapper.mapToCurrencyString(currencyAmountDTO.getCurrency()));
        }
    }

    protected Collection<TradeDTO> tradeSetToTradeDTOCollection(Set<Trade> set) {
        if (set == null) {
            return null;
        }
        ArrayList<TradeDTO> collection = new ArrayList<TradeDTO>(set.size());
        for (Trade trade : set) {
            collection.add(this.tradeMapper.mapToTradeDTO(trade));
        }
        return collection;
    }
}

