/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.util.mapper;

import org.knowm.xchange.dto.trade.LimitOrder;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.mapstruct.Named;
import org.mapstruct.NullValuePropertyMappingStrategy;
import tech.cassandre.trading.bot.domain.Order;
import tech.cassandre.trading.bot.dto.trade.OrderDTO;
import tech.cassandre.trading.bot.dto.util.CurrencyAmountDTO;
import tech.cassandre.trading.bot.dto.util.CurrencyPairDTO;
import tech.cassandre.trading.bot.util.mapper.CurrencyMapper;
import tech.cassandre.trading.bot.util.mapper.StrategyMapper;
import tech.cassandre.trading.bot.util.mapper.TradeMapper;
import tech.cassandre.trading.bot.util.mapper.UtilMapper;

@Mapper(uses={UtilMapper.class, CurrencyMapper.class, TradeMapper.class, StrategyMapper.class}, nullValuePropertyMappingStrategy=NullValuePropertyMappingStrategy.IGNORE)
public interface OrderMapper {
    @Mappings(value={@Mapping(source="id", target="orderId"), @Mapping(target="id", ignore=true), @Mapping(source="source", target="amount", qualifiedByName={"mapLimitOrderToOrderDTOAmount"}), @Mapping(source="source", target="cumulativeAmount", qualifiedByName={"mapLimitOrderToOrderDTOCumulativeAmount"}), @Mapping(source="source", target="averagePrice", qualifiedByName={"mapLimitOrderToOrderDTOAveragePrice"}), @Mapping(source="source", target="limitPrice", qualifiedByName={"mapLimitOrderToOrderDTOLimitPrice"}), @Mapping(source="instrument", target="currencyPair"), @Mapping(target="strategy", ignore=true), @Mapping(target="trades", ignore=true), @Mapping(target="trade", ignore=true)})
    public OrderDTO mapToOrderDTO(LimitOrder var1);

    @Named(value="mapLimitOrderToOrderDTOAmount")
    default public CurrencyAmountDTO mapLimitOrderToOrderDTOAmount(LimitOrder source) {
        CurrencyPairDTO cp = new CurrencyPairDTO(source.getInstrument());
        if (source.getOriginalAmount() != null && source.getInstrument() != null) {
            return CurrencyAmountDTO.builder().value(source.getOriginalAmount()).currency(cp.getBaseCurrency()).build();
        }
        return null;
    }

    @Named(value="mapLimitOrderToOrderDTOCumulativeAmount")
    default public CurrencyAmountDTO mapLimitOrderToOrderDTOCumulativeAmount(LimitOrder source) {
        CurrencyPairDTO cp = new CurrencyPairDTO(source.getInstrument());
        if (source.getCumulativeAmount() != null && source.getInstrument() != null) {
            return CurrencyAmountDTO.builder().value(source.getCumulativeAmount()).currency(cp.getBaseCurrency()).build();
        }
        return null;
    }

    @Named(value="mapLimitOrderToOrderDTOAveragePrice")
    default public CurrencyAmountDTO mapLimitOrderToOrderDTOAveragePrice(LimitOrder source) {
        CurrencyPairDTO cp = new CurrencyPairDTO(source.getInstrument());
        if (source.getAveragePrice() != null && source.getInstrument() != null) {
            return CurrencyAmountDTO.builder().value(source.getAveragePrice()).currency(cp.getQuoteCurrency()).build();
        }
        return null;
    }

    @Named(value="mapLimitOrderToOrderDTOLimitPrice")
    default public CurrencyAmountDTO mapLimitOrderToOrderDTOLimitPrice(LimitOrder source) {
        CurrencyPairDTO cp = new CurrencyPairDTO(source.getInstrument());
        if (source.getLimitPrice() != null && source.getInstrument() != null) {
            return CurrencyAmountDTO.builder().value(source.getLimitPrice()).currency(cp.getQuoteCurrency()).build();
        }
        return null;
    }

    @Mappings(value={@Mapping(target="createdOn", ignore=true), @Mapping(target="updatedOn", ignore=true)})
    public Order mapToOrder(OrderDTO var1);

    @Mappings(value={@Mapping(target="createdOn", ignore=true), @Mapping(target="updatedOn", ignore=true), @Mapping(target="trades", ignore=true)})
    public void updateOrder(OrderDTO var1, @MappingTarget Order var2);

    @Mappings(value={@Mapping(source="trades", target="trades"), @Mapping(target="trade", ignore=true)})
    public OrderDTO mapToOrderDTO(Order var1);
}

