/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.util.mapper;

import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import tech.cassandre.trading.bot.dto.util.CurrencyAmountDTO;
import tech.cassandre.trading.bot.dto.util.CurrencyDTO;
import tech.cassandre.trading.bot.dto.util.CurrencyPairDTO;
import tech.cassandre.trading.bot.util.jpa.CurrencyAmount;
import tech.cassandre.trading.bot.util.mapper.CurrencyMapper;

public class CurrencyMapperImpl
implements CurrencyMapper {
    @Override
    public CurrencyDTO mapToCurrencyDTO(Currency source) {
        if (source == null) {
            return null;
        }
        CurrencyDTO.Builder currencyDTO = CurrencyDTO.builder();
        currencyDTO.code(source.getCurrencyCode());
        return currencyDTO.build();
    }

    @Override
    public CurrencyPairDTO mapToCurrencyPairDTO(CurrencyPair source) {
        if (source == null) {
            return null;
        }
        CurrencyPairDTO.CurrencyPairDTOBuilder currencyPairDTO = CurrencyPairDTO.builder();
        currencyPairDTO.baseCurrency(this.mapToCurrencyDTO(source.base));
        currencyPairDTO.quoteCurrency(this.mapToCurrencyDTO(source.counter));
        return currencyPairDTO.build();
    }

    @Override
    public CurrencyAmountDTO mapToCurrencyAmountDTO(CurrencyAmount source) {
        if (source == null) {
            return null;
        }
        CurrencyAmountDTO.CurrencyAmountDTOBuilder currencyAmountDTO = CurrencyAmountDTO.builder();
        currencyAmountDTO.value(source.getValue());
        currencyAmountDTO.currency(this.mapToCurrencyDTO(source.getCurrency()));
        return currencyAmountDTO.build();
    }
}

