/*
 * Decompiled with CFR 0.152.
 */
package tech.cassandre.trading.bot.util.mapper;

import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.instrument.Instrument;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import tech.cassandre.trading.bot.dto.util.CurrencyAmountDTO;
import tech.cassandre.trading.bot.dto.util.CurrencyDTO;
import tech.cassandre.trading.bot.dto.util.CurrencyPairDTO;
import tech.cassandre.trading.bot.util.jpa.CurrencyAmount;

@Mapper
public interface CurrencyMapper {
    default public String mapToCurrencyString(CurrencyDTO source) {
        if (source != null) {
            return source.toString();
        }
        return null;
    }

    default public CurrencyDTO mapToCurrencyDTO(String value) {
        return new CurrencyDTO(value);
    }

    @Mapping(source="currencyCode", target="code")
    public CurrencyDTO mapToCurrencyDTO(Currency var1);

    default public String mapToCurrencyPairString(CurrencyPairDTO source) {
        return source.toString();
    }

    default public CurrencyPairDTO mapToCurrencyPairDTO(Instrument source) {
        CurrencyPair cp = (CurrencyPair)source;
        CurrencyDTO base = new CurrencyDTO(cp.base.getCurrencyCode());
        CurrencyDTO quote = new CurrencyDTO(cp.counter.getCurrencyCode());
        return CurrencyPairDTO.builder().baseCurrency(base).quoteCurrency(quote).build();
    }

    default public CurrencyPairDTO mapToCurrencyPairDTO(String source) {
        return new CurrencyPairDTO(source);
    }

    @Mappings(value={@Mapping(source="base", target="baseCurrency"), @Mapping(source="counter", target="quoteCurrency")})
    public CurrencyPairDTO mapToCurrencyPairDTO(CurrencyPair var1);

    @Mappings(value={@Mapping(source="value", target="value"), @Mapping(source="currency", target="currency")})
    public CurrencyAmountDTO mapToCurrencyAmountDTO(CurrencyAmount var1);

    default public CurrencyPair mapToCurrencyPair(CurrencyPairDTO source) {
        return new CurrencyPair(source.getBaseCurrency().getCode(), source.getQuoteCurrency().getCode());
    }
}

